/* V3,  01.2015
   Tastenbelegungen auf den Joysticks auslesen und als htm in Kneeboard/Referenz anzeigen
   (war "Tastenbelegung.ahk", jetzt -> (JoyTasten.ahk")
   Erwartet: 
     eine Tabelle All-DescrAxmlnames_DE.txt in deutsch
     eine Tabelle All-DescrAxmlnames_EN.txt in englisch
     mit 2 Spalten: - 1. Beschreibung <Tab> 2. FNamen <Zeilenschaltung>
   Erzeugt:
     eine "JoystickKeys.htm", die in das Verzeichnis "Zoystick" im Airplanes-Ordner kopiert wird
      und patcht die Aircraft.cfg der ausgewhlten Flugzeuge
   Neue Version:
   - Bercksichtigung unterschiedlicher Formatierungen in aircraft.cfg's von Addons      
   V3: erweitert um die Mglichkeit unterschiedlicher Belegungen fr verschiedene Flugzeuge 
       (Standard.xmls whlen). Verlangte auch nderungen in JoyClean -> JoyClean-V3

*/

; *----- globale Variablen ------*
Global zlende, tabs
zlende = `r`n
tabs := chr(9)

Global flugsmax := 64, varsmax := 16       ; Beschrnkung?!
Global joymax := 4                         ; nur 4 Joystick-Spalten im Kneeboard
Global joywahl, joynum
Global flugzeuge, varianten                ; einfache String-Var'n
Global fname := Object()
fname.Anzahl := 5*32                       ;* (Besch + 4(Spalten)) * 32(Tasten) 
flugzeug := Object()
f := Object()                              ; Objekte flugzeug() und f() eigentlich
f.Anzahl := 32*2                           ;   berflssig!?

refkomment := "  //Ref:"
refex := "added"

; *------ XML-Tags etc. ------*
tag1  := "<Entry>"
tag2  := "</Entry>"
tag3  := "<Index>"
tag4  := "</Index>"
tag5  := "<Down>"
tag6  := "</Down>"

/* -- spter??? --
tag7  := "<Up>"
tag8  := "</Up>"
tag9  := "<DownVal>"
tag10 := "</DownVal>"
tag11 := "<UpVal>"
tag12 := "</UpVal>"
*/

; *------ HTML-Tags -------*
rtag := "<tr>"
rtag_e := "</tr>"
ztag := "<td>"
zctag := "<td align=center>"
ztag_e := "</td>"

; *------------------------ Dateien und Pfade --------------------------------*
; *-- Pfade zu Standard.xml und zu den Airplanes werden automatisch erkannt
RegRead, fsxpfad, HKCU, Software\Microsoft\Microsoft Games\Flight Simulator\10.0, AppPath
joyheader := fsxpfad
fsxpfad := fsxpfad . "SimObjects\Airplanes\"

standpf := A_AppData . "\Microsoft\FSX\Controls\"
tabelpf := "Data\"      ; Unterverzeichnis von Joytasten
zielpf  := A_MyDocuments . "\KneeboardTools\JoyKeyData\"   ; htm-Datei erst speichern, dann in fsxpfad\flgzg verteilen
zoypf   := "Zoystick"
standi   =              ; Inhalt von Standard.xml
tabelli  =              ; Inhalt von meiner Tastentabelle
aircfg   =              ; Inhalt von aircraft.cfg wg. Varianten fltsim.x
standard  := "Standard.XML"
tabelle_de := "All-DescrAxmlNames_DE.txt"  
tabelle    := "All-DescrAxmlNames_EN.txt"
zieldat    := "Joystickkeys"
zieldathtm := zieldat . ".htm"
aircraft  := "aircraft.cfg"
joyheader .= "Uires\blank.htm"     ; die Standard-Ref.htm-Datei aus C172SP

;*!Test---
;*! standpf := "Daten\"    ;*!!! zum Test
;*! fsxpfad := "D:\Work\FS\SDK\Modelling\Airplane-Texturen\"
;*!Test---

tabelle := tabelpf . tabelle       ; wird spter nochmal nach Auswahl gesetzt
standard := standpf . standard
ziel := zielpf . zieldathtm
joytail := tabelpf . joytail

; *------------------------- Joysticks bestimmen ----------------------------*

If Dateilesen(standi, standard)
   Abbrechen("unable to open Standard.XML")

joysticks := LiesStandard(standi, joys)    ; aus Standard.xml Joystick-Eintrge lesen

; *------------ jetzt Flugzeuge & Varianten einlesen aus Airplanes ------------*

IfNotExist, %fsxpfad%%zoypf%               ; schon hier (wg. Stopperfunktion)
  FileCreateDir, %fsxpfad%%zoypf%          ; Zoystick ggbf. anlegen

flugs := 0
Loop, %fsxpfad%*, 2                        ; *----- uere Schleife Airplanes
 {
   xyz := fsxpfad . A_LoopFileName . "\" . aircraft 
   IfExist, %xyz%                          ; falls fremde Verzeichnisse in \Airplanes\ existieren, nix tun
    {
     flugzeug[A_Index,0] := A_LoopFileName
     flugs += 1
     aircfg =
     If Dateilesen(aircfg, fsxpfad . flugzeug[A_Index,0] . "\" . aircraft)  ; Lesefehler?
       Abbrechen("unable to open Aircraft.cfg in \" . flugzeug[A_Index,0] . "\")
     x := 0
     Loop                                  ; *----- innere Schleife Varianten
      {
        x := InStr(aircfg, "[fltsim.", F, x+1)
        If x <= 0
          Break
        y := InStr(aircfg, "[fltsim.", F, x+1) ; den nchsten suchen
        If !y                                                        ; Update:
          y := InStr(aircfg, zlende . "[", F, x)                          ; ... war [GENERAL
        flugzeug[flugs, A_Index] := LiesTitle(aircfg, zlende . "title", x) ; "=" fgt die Func hinzu
        z := InStr(aircfg, "=" . zieldat, F, x)
        If (z > 0 AND z < y)
          flugzeug[flugs, A_Index] := "+" . flugzeug[flugs, A_Index]
     }
   }
}

; **------------------------ GUI einrichten -----------------------------**

GUI, New, Resize, Select joysticks and airplanes
GUI, Margin, , 4
Gui, Font, s9 q5, Times      ; Schriftart und Gre setzen

Gui, Add, Text, , Joystick-Select `n(klick separately in the desired order) 
GUI, Add, ListBox, W375 R%joys% Vjoysticks gNeuJoy, %joysticks%

Gui, Font, Bold
GUI, Add, CheckBox, Vsprache Section, Descriptions in german
GUI, Add, CheckBox, Vseparat gSeparat ys +right , Joystickkeys separately per airplane     ;*!!! +right???
Gui, Font
Gui, Add, Text, xs, 
Gui, Add, Text, , Activate the airplanes (variants) you want   ;*!!!???
y := A_ScreenHeight                             ; Hhe des Screens holen
x := Ceil(y/18) -joys -20

GUI, Add, TreeView,  VScroll  W375 R%x% gFlugzaehler Checked AltSubmit
Loop, %flugs%
 {
   f[A_Index,0] := TV_Add(flugzeug[A_Index,0])  ; Element-IDs ins Arr f[]
   flugzeug[A_Index,0] := ""                    ; Eintrag nach dem ins Gui stellen entfernen
   x:= A_Index
   scheck := 0
   Loop, %varsmax%                              ;  Anzahl Varianten beschrnken !?
    {
      If flugzeug[x, A_Index] = ""
        Break
      If SubStr(flugzeug[x, A_Index], 1, 1) = "+"
      {
        flugzeug[x, A_Index] := SubStr(flugzeug[x, A_Index], 2)
        scheck := 1
      }
      f[x, A_Index] := TV_Add(flugzeug[x, A_Index], f[x, 0])
      If scheck = 1
        scheck := TV_Modify(f[x, A_Index], "Check")
   }
   If scheck
     scheck := TV_Modify(f[A_Index, 0], "Check")
}
TV_Modify(f[1,0], "Select Expand")

GUI, Add, Button, Default, READY
GuiControl, Move, READY, X180

GUI, Show, AutoSize
return

; *---------------------- Subroutinen ----------------------------------------*
NeuJoy:                              ; *--- von ListBox ausgelst
GuiControlGet, xyz, , joysticks
xyz := SubStr(xyz, InStr(xyz, "]")+1)
  If !InStr(joywahl, xyz)            ; Doppel-Eintrge verhindern
  {
    joywahl .= xyz . "|"
    joynum += 1
    x := InStr(joysticks, xyz)
    joysticks := SubStr(joysticks, 1, x-1) . "[" . joynum . "]" . SubStr(joysticks, x)
    GuiControl, , joysticks, |%joysticks%
  }
Return

Flugzaehler:                         ; *--- von TreeView ausgelst 
If A_GuiEvent = normal               ;  "normal" bei AltSubmit, sonst S = Neue Auswahl
 {
  x := TV_GetNext()                  ; das allererste Element
  TV_Modify(x, "-Check")             ;    unchecken
  Loop                               ; alle Elemente durchscannen
   {
     x := TV_GetNext(x, "Full")      ; das jeweils nchste
     If x = 0                        ; Ende erreicht?
       Break
     y := TV_GetParent(x)            ; Ermittelt die ID-Nummer des Elternelements 
     If y = 0                        ; wenn es keins hat, ist es selbst Elternelement=Flugzeug 
       TV_Modify(x, "-Check")        ;   dann prventiv uncheck,
     else                            ;   denn es wird gleich
      {
       If TV_Get(x, "Checked")
         TV_Modify(y, "Check")       ;   wieder neu gesetzt, falls ein Unterelement gecheckt ist
     }
  }
}
Return

Separat:                             ; Checkbox Belegung pro Flzg angeklickt
 FileSelectFile, xyz, 3, %standpf%, Select a '...Standard...'.xml, *.xml
 If xyz =
 	 Abbrechen("Cancelled by User")
 If (xyz <> standard)
 { If Dateilesen(standi, xyz)
     Abbrechen("unable to open '...Standard...'.XML")
   joysticks := LiesStandard(standi, joys)    ; aus Standard.xml Joystick-Eintrge lesen
   joywahl =
   joynum := 0
   GuiControl, , joysticks, |%joysticks%
 }
 Loop, %flugs%                                  ; alle unchecken
  { TV_Modify(f[A_Index,0], "-Check")            ; Element-IDs im Arr f[]
    x:= A_Index
    Loop, %varsmax%                              ;  Anzahl Varianten beschrnken !?
     { TV_Modify(f[x, A_Index], "-Check")
     }
  }
Return

; *-------------------- Ende der Gui-Subroutine ------------------------------*

ButtonREADY:                            ; <== hier geht Hauptprogramm weiter
GUI, Submit


; **========================= MAIN ==========================================**

flugzeuge =
flugs := 0
x := TV_GetNext()                        ; *--- die Ausgewhlten Flugzeug-Varianten abrufen 
Loop                                     ;       beim allerersten anfangen (ist ein Flugz.)
 {                                       ;       alle durchscannen,
   x := TV_GetNext(x, "Checked")         ;       aber nur die gecheckten
   If x = 0
     Break                               ; wenn alle ermittelt, Ende der Loop
   y := TV_GetParent(x)                  ; Ermittelt die ID-Nummer des Oberelements 
   If y                                  ; Nur, wenn Variant gewhlt
    {                                    ;  wenn Flugzeug, dann nix tun
     TV_GetText(xyz, y)                  ; dazu den Text = Flugzeug(Ordner)
     IfNotInString, flugzeuge, %xyz%
     {
        flugs += 1
        vars := 1                        ; Neuer Anfang fr Variantenzhlung
        flugzeug[flugs, 0] := xyz
        flugzeuge .= xyz . "|"           ; Flugzeuge in Var sammeln
      }
     TV_GetText(xyz , x)
     flugzeug[flugs, vars] := xyz
     vars += 1
     flugzeug[flugs, vars] := ""         ; Der Stopper beim Auslesen 
   }
}


joysticks := joywahl                     ; einzelne wurden ausgewhlt
If SubStr(joysticks, StrLen(joysticks), 1) = "|"
  StringTrimRight, joysticks, joysticks, 1

joys := 0
Loop, Parse, joysticks, |                ;* die ausgewhlten ins Feld ?
 {
    joys%A_Index% := LTrim(A_LoopField)  ; Leerzeichen am Anfang entfernen
    joys += 1
}
If !joys
	Abbrechen("No joystick selected")

; *------------------- Restliche Dateien einlesen ----------------------------*

If sprache                                  ; Englisch gewhlt?
  tabelle := tabelpf . tabelle_de 

If Dateilesen(tabelli, tabelle)   ; Lesefehler?
   Abbrechen("unable to open command table")

tabelli .= zlende                           ; fr alle Flle am Ende nochmal neue Zeile

If Dateilesen(joyheader, joyheader)
  Abbrechen("unable to open blank.htm from UIRES")
x := InStr(joyheader, "<Body>") -1
StringLeft, joyheader, joyheader, x

IfNotExist, %zielpf%
  FileCreateDir, %zielpf%                   ; JoyKeyData in MyDocs ggbf. anlegen
else IfExist, %ziel%
  FileDelete, %ziel%                        ;  *--- erst alte Datei Joystickkeys.htm lschen

FileAppend %joyheader%, %ziel%              ;  *--- Hier beginnt das Schreiben
If errorlevel
  Abbrechen("unable to create JoystickKeys.htm")

; *-------------------- Den HTML-Header bauen --------------------------------*
joyheader = 
(
<head>
<title>Joystickkeys Assignment</title>
 </head>
<body>
 <P><font face="Arial" style="font-size: 14pt"><B><U>Joystickkeys Assignment</U></B></font><BR>
 <font face="Arial" style="font-size: 9pt">
)
FileAppend %joyheader%, %ziel%

If !joys
	FileAppend, no joystick chosen, %ziel%
Else
 { Loop, %joys%                             ; erst fr die Auflistung der Joysticks
    { If InStr(joys%A_Index%, "Slew")
        joyheader := "Slew" . " = " . joys%A_Index% . "<BR>"
      else
        joyheader := "Joy-" . A_Index . " = " . joys%A_Index% . "<BR>"
      FileAppend %joyheader%, %ziel%
    }
 }
joyheader = 
(
 </P> 
 <P>
 <table border="1" cellpadding="0" cellspacing="0" font face="Arial" style="font-size: 9pt"
        style="border-collapse: collapse" bordercolor="#C0C0C0" width="378" id="AutoNumber1">
 <tr> <td width="220"><b>Description of Keys</b></td>
)
FileAppend %joyheader%, %ziel%
Loop, %joys%                             ; jetzt die Tabelle selbst
 {
   joyheader := "<td width=""90"" align=center><b> "
   If InStr(joys%A_Index%, "Slew")
     joyheader .= "Slew  </b></td> "
   else
     joyheader .= "Joy-" . A_Index . "  </b></td> "
   FileAppend %joyheader%, %ziel%
}
joyheader = </tr>`r`n
FileAppend %joyheader%, %ziel%

; *----------------!  Tabelle erzeugen !--------------------------------------*

Joysticktasten := FileOpen(ziel, "a")

Loop, %joys%
 {
   If MakeTab(standi, tabelli, ">" . joys%A_Index% . "{", Joysticktasten, A_Index)
     Abbrechen("Error while writing " . ziel . )
 }

Joysticktasten.Close()

; *------------ zum Schluss Tabellenende und HTML-Ende anhngen: -------------*
joyheader = </table> </P>`r`n
FileAppend %joyheader%, %ziel%

; *------------ jetzt Bild einbinden oder nicht ------------------------------*

FileSelectFile, joytail, 3, %zielpf%, Inlude picture? Select or cancel, *.GIF; *.JPG; *.TIF
If joytail =                                       ; kein Bild
  joyheader = </body></html>`r`n
else
 {
   xyz := joytail
   StringTrimLeft, joytail, joytail, InStr(joytail, "\", F, 0)
   FileCopy, %xyz%, %fsxpfad%%zoypf%, 1            ; vom Ursprungsort nach Zoystick
   joyheader = <P><Table>`r`n<tr><td><img src="../%zoypf%/%joytail%"></td></tr>`r`n</table></P>`r`n</Body></html>
}
FileAppend %joyheader%, %ziel%

;*!!!weg! stattdessen in Schleife Filcopy (entsprechend JoyClean anpassen!)
;;FileCopy, %ziel%, %fsxpfad%%zoypf%, 1              ; Joysticktasten.htm nach Zoystick kopieren&berschreiben

; *---------- patchen der aircraft.cfg's bei ausgewhlten Varianten ----------*

If SubStr(flugzeuge, StrLen(flugzeuge), 1) = "|"
  StringTrimRight, flugzeuge, flugzeuge, 1
If SubStr(varianten, StrLen(varianten), 1) = "|"
  StringTrimRight, varianten, varianten, 1

If !joys
	Goto GuiClose                           ; Abbrechen ohne Patchen

Loop, %flugs%                             ; Schleife alle gewhlten Flugzeuge
 {
   xyz := fsxpfad . flugzeug[A_Index, 0] . "\" . aircraft
   IfExist, %xyz%
    {
      If Dateilesen(aircfg, xyz)   ; Lesefehler?
        Abbrechen("unable to open Aircraft.cfg in " . A_LoopField)
      flieger := A_Index
      schreib = 0
      x := 1
      Loop, %varsmax%                               ; Schleife deren gewhlte Varianten
       { refkom := refkomment
         If flugzeug[flieger, A_Index] = ""
           Break                                   ; alle durch
         z := A_Index
         Loop
          { 
            y := InStr(aircfg, "[fltsim.", F, x)      ; laut Tab vorhanden, also kein Ifnot
            If !y
              Abbrechen("invalid structure in aircraft.cfg of " . flugzeug[A_Index,0])
          	x := y+1
          	If (LiesTitle(aircfg, zlende . "title", y) = flugzeug[flieger, z])
          	  Break
          }
         y := InStr(aircfg, "kb_reference", F, x)      ; Pointer auf Pos nach "="
         If !y
         	{ y := InStr(aircfg, zlende . "kb_", F, x)
            If !y
            	y := Instr(aircfg, zlende, F, x)
            y += 2
            aircfg := SubStr(aircfg, 1, y-1) . "kb_reference=" . zlende . SubStr(aircfg, y)
            refkom .= refex
          }
         x := y
         x := InStr(aircfg, "=", F, x) +1              ; Pointer auf Pos. nach =
         y := InStr(aircfg, zlende, F, x)              ; Pointer Zeilenende
         If (SubStr(aircfg, x, StrLen(zieldat)) <> zieldat)  ; war schon gepatcht?
          {
           schreib := 1
           aircfg := SubStr(aircfg, 1, x-1) . zieldat . refkom . SubStr(aircfg, x)
         }
      }                                                ; alter Ref-Dateiname bleibt auskommentiert erhalten
      If schreib
       {
        FileAppend, %aircfg%, %xyz%_NEU
        If !Errorlevel
        {
          FileDelete, %xyz%
          If !Errorlevel
            FileMove, %xyz%_NEU, %xyz%, 
        }
      }
;     ; Joystickkeys.htm von MyDoc in Airplane-Verzeichnisse kopieren:
      xyz := fsxpfad . flugzeug[A_Index, 0] . "\" . zieldathtm
      FileCopy, %zielpf%%zieldathtm%, %xyz%, 1
   }
}      

; msgbox, 
;ListVars
;Pause

; *----------------------------- Ende ----------------------------------------*

If !separat
	flugzeuge =
Else
	IfInString, flugzeuge, |
	  flugzeuge := " airplanes " . flugzeuge
  Else
    flugzeuge := " airplane " . flugzeuge

If flugs and joys
  MsgBox, JoystickKeys.htm for showing in Kneeboard of the%flugzeuge% successfully created
GuiClose:
Abbruch:
ExitApp


; **============================ Funktionen =================================**

Abbrechen(fehlertxt)
 {
  MsgBox, Canceled - %fehlertxt%
  Gosub, Abbruch
}

Dateilesen(ByRef dateiinh, dateinam)   ; Datei in Variable einlesen
 {
  FileRead, dateiinh, %dateinam%
  Return Errorlevel
}

LiesStandard(ByRef stdinh, ByRef joys)       ; liest Joystick-Namen aus Standard.xml's
{ startdev := "<SimControls.Map>"            ; Anfang einer Steuerungs-Sektion
  namedev  := "<Name>"                       ; Name der Sektion
;  enddev   := "</SimControls.Map>"           ; Ende einer... !bisher nicht gebraucht!
  joys := 1
  x := 1
  Loop                          ; alle Joystickeintrge aus Standard.xml auslesen
   {
    x := InStr(stdinh, startdev, false, x)
    If x = 0
      Break
    x := InStr(stdinh, namedev, false, x) + 6
    joys%joys% := LiesParam(stdinh, x, "<")
    If InStr(joys%joys%, "{")
      joys%joys% := Trim(LiesParam(joys%joys%, 1, "{"), "{")
    If InStr(joys%joys%, "KEYBOARD") OR InStr(joys%joys%, "Mouse Yoke") OR Instr(joys%joys%, "Mouse Look")
      joys%joys% := ""
    else
      joys += 1
    If (joys-1 > (joymax * 2))                ; mehr als 8?
     {
       MsgBox, Too many joystick entrys - %joys% in Standard.xml`nUp to 4 entrys can be shown in kneeboard
       Break
    }
  }
  joys -= 1
  If !joys
    Abbrechen("No joystick entrys found in Standard.xml")
  joysticks$ =
  Loop, %joys%
   {
     joysticks$ := joysticks$ . " " . joys%A_Index% . "|"
   }
  Return joysticks$
}


; *--- liest aus Standard.xml und Tabelle und erzeugt htm-Tab ---*
MakeTab(ByRef standinh, ByRef tabinh, joy, Joysticktasten, joynr)  
 {
 ;;; .... tag1=<Entry>, tag3=<Index>   *!!!
   Global rtag, rtag_e, ztag, zctag, ztag_e, joymax, tag1, tag3
   nxtpos := InStr(standinh, joy)
   If nxtpos = 0
     Abbrechen("Joystick entry " . joy . " not found")
   endpos := InStr(standinh, "</SimControls.Map>", 0, nxtpos)
   joyteil := SubStr(standinh, nxtpos, endpos-nxtpos)
   nxtpos := 1
;  *-- zentrale Schleife pro Tasteneintrag --*     
   While InStr(joyteil, tag3, 0, nxtpos)
   {
      fname[A_Index, 1] := Liesfname(joyteil, A_Index, nxtpos, ftnr)
 ;;;   msgbox, nach Liesfname: ftnr:%ftnr% nxtpos:%nxtpos%  ;*!!!
      If ftnr =
        Break
      fname[A_Index, 2] := ftnr
      If ftnr <> POV
      {
        fname[A_Index, 2] += 1
        fname[A_Index, 2] := "T" . fname[A_Index, 2]
      }
      fname[A_Index, 1] := LiesBesch(tabinh, fname[A_Index, 1])
      zeile := rtag . ztag . fname[A_Index,1] . ztag_e
      Loop % joynr-1
      {
        zeile .= ztag . ztag_e
      }
      zeile .= zctag . fname[A_Index,2] . ztag_e 
      Loop % joymax-joynr
      {
        zeile .= ztag . ztag_e
      }
      zeile .= rtag_e . "`r`n"
 ;;;  msgbox % joynr ". " joy " T:"ftnr ":`n" zeile   ;*!!!

      Joysticktasten.Write(zeile)
   }
   Return Errorlevel
}

Liesfname(dateiinh, apos, ByRef nxtpos, ByRef ft)   ; XML-Namen & Tastennr. aus Standard.xml lesen
{
;;tag1=<Entry>, tag2=</Entry>, tag3=<Index>, tag4=</Index>, tag5=<Down>; tag6=</Down>
   Global tag1, tag2, tag3, tag4, tag5, tag6
   ft =
   nxtpos  := InStr(dateiinh, tag1, 0, nxtpos)
   If nxtpos = 0                 ; wenn kein Entry mehr
   { nnxtpos := InStr(dateiinh, "<POV>")
     If nnxtpos = 0              ; auch kein POV mehr
     { Return                    ; dann raus
     }Else
     { nxtpos := nnxtpos         ; nur noch POV
       ft := "POV"
     }
   }Else      ; nxtpos Nicht 0    dann Tastennr holen
   { nxtpos  := InStr(dateiinh, tag3, 0, nxtpos) + StrLen(tag3)
     nnxtpos := InStr(dateiinh, tag4, 0, nxtpos)
     ft := SubStr(dateiinh, nxtpos, nnxtpos-nxtpos)
   }
   nnxtpos := InStr(dateiinh, tag5, 0, nnxtpos) + StrLen(tag5) ; jetzt FName
   nxtpos := InStr(dateiinh, tag6, 0, nnxtpos)
;;;  msgbox % "Liesfname: " nxtpos "|" nnxtpos "`n" SubStr(dateiinh, nnxtpos, nxtpos-nnxtpos)  ;*!!!
   Return SubStr(dateiinh, nnxtpos, nxtpos-nnxtpos)
}

LiesBesch(ByRef dateiinh, fname)                      ; F-Beschreibung aus Tabelle auslesen
 {                                                    ; Voraussetzung: Tab nur 2 Spalten
  Global zlende, tabs
  y := InStr(dateiinh, tabs . fname . zlende)         ; FSX-F-Namen suchen
  If !y
    Abbrechen(fname . " not found in command table")
  x := InStr(dateiinh, zlende, 0, y-StrLen(dateiinh)) ; von dort nach links Zeilenanfang
  x += 2
  Return SubStr(dateiinh, x, y-x)                     ; = Befehls-Beschreibung
}

LiesParam(ByRef dateiinh, pos, muster)                ; liest Joysticknamen aus Standard.xml
 {
  y := InStr(dateiinh, muster , false, pos)
  If !y
    Abbrechen("no device name found in Standard.xml")
  Return SubStr(dateiinh, pos, y-pos)
}

LiesTitle(ByRef dateiinh, pname, startpos)            ; liest Flugzeugvarianten aus aircraf.cfg
 {
  x := InStr(dateiinh, pname, F, startpos)            ; erst ohne "="
  If !x
    Return "no " . pname
  x := InStr(dateiinh, "=", F, x)                     ; wo ist =?
  If !x
    Return "no " . pname
  y := InStr(dateiinh, zlende, 0, x) 
  z$ := SubStr(dateiinh, x+1, y-x-1)
  Return Trim(z$, " tnr")
}
