/* V3 01.2015
   Stellt den Normalzustand in allen Aircraft.cfg-s wieder her,
    d.h., setzt den Eintrag kb_reference=../Zoystick/JoystickKeys
    wieder auf kb_reference=AirplaneName_ref
   Update Januar 2015
     - angepasst an uneinheitlich formatierte aircraft.cfg's
*/

; *--- benutzt ---*
zlende = `r`n
flugzeug =

; *--------- Dateien und Pfade ---------*
; *-- Pfade zu Standard.xml und zu den Airplanes werden automatisch erkannt
RegRead, fsxpfad, HKCU, Software\Microsoft\Microsoft Games\Flight Simulator\10.0, AppPath
fsxpfad := fsxpfad . "SimObjects\Airplanes\"

zoypf := "Zoystick"
aircraftcfg := "aircraft.cfg"                           ; Dateiname
zieldat := "Joystickkeys"                               ; V3
zieldathtm := zieldat . ".htm"
aircfg =                                                ; Dateiinhalt
geaendert =
refkomment := "//Ref:"
refex := "added"
nixmeld = %1%                                           ; wenn durch JoyUnInstall aufgerufen

; *---------- Beginn ----------*

Loop, %fsxpfad%*, 2                                     ; *----- uere Schleife Airplanes
{
   aircraft := fsxpfad . A_LoopFileName . "\" . aircraftcfg
   IfExist, %aircraft%                                  ; falls fremde Verzeichnisse in \Airplanes\ existieren, nix tun
   {  If Dateilesen(aircfg, aircraft)
        Abbrechen("Error while reading Aircraft.cfg in " . A_LoopFileName)
      x := 1
      y := 0
      Loop                                              ; *------ innere Schleife fltsims
      {
         fehler =
         x := InStr(aircfg, zlende . "kb_reference", F, x+1) ; !ohne =!  alle Zeilen mit kb_reference
         If !x
            Break
         x += 14
         x := InStr(aircfg, "=", F, x)
         If !x
            Break
         x += 1
         If (SubStr(aircfg, x, StrLen(zieldat)) = zieldat)  ; nach mit Joystickkeys gepatchten absuchen
         {
            z := InStr(aircfg, zlende, F, x)
            y := InStr(aircfg, refkomment, F, x)
            If (y=0 OR y>z)                             ; Zeile ist nicht wie erwartet?
            {
               fehler = no original entry found
               y := z                                   ; ab Zeilenende weiter
            }  
            Else
            { y += StrLen(refkomment)                   ; //Ref: berspringen

            	If (InStr(aircfg, refex, F, y-1) OR InStr(aircfg, "zugefgt", F, y-1)) ; steht dort "added" oder das frhere Wort?
            	 { 
            	 	x := InStr(aircfg, zlende, F, x-StrLen(aircfg)) ; x-strlen = negativ, daher Suche rckwrts
            	 	 y := InStr(aircfg, zlende, F, y)
            	 }
            }
            aircfg := SubStr(aircfg, 1, x-1) . fehler . SubStr(aircfg, y)
         }
      }  ;LoopEnde
      If y                                              ; dann hat es nderung gegeben
      {
         geaendert = 1                                  ; fuers Programmende
         FileMove, %aircraft%, %aircraft%_Bak, 1
         FileAppend, %aircfg%, %aircraft%
         If Errorlevel
            MsgBox, Error while writing Aircraft.cfg in %A_LoopFileName%
         else
            FileDelete, %aircraft%_Bak
      }
   }
   IfExist, %fsxpfad%%A_LoopFileName%\%zieldathtm%         ; gibts das Joystickkeys.htm
     FileDelete, %fsxpfad%%A_LoopFileName%\%zieldathtm%
}

IfExist, %fsxpfad%%zoypf%
{
  MsgBox, 4, Deleting folders, Remove folder \%zoypf%\ from \Airplanes\ ?
  IfMsgBox Yes
  { IfExist, %fsxpfad%%zoypf%
     { FileDelete, %fsxpfad%%zoypf%\*.*
       FileRemoveDir, %fsxpfad%%zoypf%
       geaendert = 2
     }
  }
}

; *------- Ende -------*
; msgbox, 
;ListVars
;Pause

zoypf =
If geaendert > 1
  zoypf = and \Zoystick removed
  
If nixmeld =
 { If geaendert
     MsgBox, All Aircraft.cfg set to default %zoypf%
   else
     MsgBox, Ready - nothing changed
}

Abbruch:
ExitApp


; **================== Funktionen ======================**

Abbrechen(fehlertxt)
 {
  MsgBox, Cancelling - %fehlertxt%
  Gosub, Abbruch
}

Dateilesen(ByRef dateiinh, dateinam)   ; Datei in Variable einlesen
 {
  FileRead, dateiinh, %dateinam%
  Return Errorlevel
}

