#Include Scr\Header.ahk
#MaxMem 512
Global regtag, idtag, lattag, lontag, endtg, startag, endtag
Global rw_str := "          Runway "
apstart := "<Ap>"
apend   := "</Ap>"
rwstart := "<Ry>"
rwend   := "</Ry>"
dat_dir = PD_MakeRwys
rwtxtdat = %apinfopf%%dat_dir%\Runways.txt
zielpf = %datapf%
runways  = AP_Runways
zielcsv := datapf . runways . ".csv"
sids    := datapf . "SIDs.xml"
sidinh =
csvinh =
txtinh =
zbv =
If Dateilesen(sidinh, sids)
Abbruch("unable to open SIDs.xml")
If Dateilesen(txtinh, rwtxtdat)
Abbruch("unable to open runways.txt (MakeRwys)")
If Dateilesen(csvinh, zielcsv)
Abbruch("unable to open runways.csv")
sidpos := 1
Loop
{
sidpos := InStr(sidinh, apstart, 1, sidpos+4)  ; "<Ap>" gesucht
If !sidpos
Break
curr_ap := Trim(SubStr(sidinh, sidpos+4, 4))
rwzl1 := Rwy_Zaehlen_CSV(csvinh, curr_ap)
x:= 0
Loop
{ x := InStr(txtinh, zlende . "Airport " . curr_ap, 1, -1, A_Index)
If !x
{ MsgBox, darf nicht passieren: %curr_ap% nicht in Runways.txt
Break
}
y := InStr(txtinh, zlende . "Airport ", 1, x+10)
If !y
y := StrLen(txtinh)
apinh := SubStr(txtinh, x, y-x)
rwzl2 := Rwy_Zaehlen_TXT(apinh)
rwx := InStr(apinh, zlende . rw_str)
If A_Index > 30
{ MsgBox, Endlosschleife`, kein "%rw_str%" gefunden
Break
}
} Until rwx   ; bis " Runway " gefunden
If (rwzl2 > (rwzl1 +2))
{ Rwy_Analyse(apinh, csvinh, curr_ap)
crossrwzlr += 1
}
}
If crossrwzlr
{ MsgBox, 33, Crosswind technique, %crossrwzlr% Airports with crosswind technique found - save data in Runways file?
IfMsgBox, OK
{ IfExist, %zielpf%%runways%.BAK
FileDelete, %zielpf%%runways%.BAK
FileMove, %zielcsv%, %zielpf%%runways%.BAK
FileAppend, %csvinh%, %zielcsv%
If Errorlevel
MsgBox, Error while writing Runway data (%runways%.csv)
Else
MsgBox, Additional runway data written to %zielcsv%
}
}Else
MsgBox, No crosswind technique found with the airports in SIDs.xml data`nor the data are up-to-date
GuiClose:
EndeUndAb:
sidinh =
txtinh =
csvinh =
ExitApp
Rwy_Zaehlen_CSV(ByRef csv, airp)
{ x := 1
Loop
{ x := InStr(csv, zlende . airp . A_Tab, 1, x+6)
If !x
Break
zlr := A_Index
}
Return zlr
}
Rwy_Zaehlen_TXT(airp)
{ x := 1
Loop
{ x := InStr(airp, zlende . rw_str, 1, x+10)
If !x
Break
zlr := A_Index * 2
}
Return zlr
}
Rwy_Analyse(api, ByRef csvi, curap)
{ endpos := 0
x := InStr(api, zlende . rw_str)
y := InStr(api, zlende . zlende, 1, x+1)
api := SubStr(api, x, y-x)
apblck := SuchApBlck_CSV(csvi, curap, endpos)
x := 1
Loop
{
y := InStr(api, zlende . rw_str, 1, x+5)
If !y
y := StrLen(api)
rwt$ := SubStr(api, x, y-x)
zbv$ := Trim(SubStr(rwt$, 19, InStr(rwt$, " centre:") -19) )
z := InStr(zbv$, "/")
rid1 := Trim(SubStr(zbv$, 1, z-1))
rid2 := Trim(SubStr(zbv$, z+1))
mehrw .= HolRwDat(rwt$, apblck, rid1, curap, 0)
mehrw .= HolRwDat(rwt$, apblck, rid2, curap, 180)
x := y
} Until (y = StrLen(api))
csvi := SubStr(csvi, 1, endpos) . mehrw . SubStr(csvi, endpos+1)
Return
}
SuchApBlck_CSV(ByRef csvi, curap, ByRef epos)
{ apos := InStr(csvi, zlende . curap)
x := apos
Loop
{ epos := InStr(csvi, zlende . curap, 1, x+1)
If !epos
Break
x := epos
}
epos := InStr(csvi, zlende, 1, x) +1
Return SubStr(csvi, apos, epos-apos)
}
HolRwDat(rwt, apblck, rid, curap, kehrs)
{ IfNotInString, apblck, %curap%%A_Tab%%rid%%A_Tab%
{ h1 = %rid% closed for landing and take-off
StringReplace, h1, h1, %A_Space%, , All
StringReplace, h2, rwt, %A_Space%, , All
IfInString, h2, %h1%
{ z$ := curap . A_Tab . rid . A_Tab . "999" . A_Tab
x := 1
zb := RW_LiesParamX(rwt, x, StrLen(rwt), " Hdg: ", " true ", 0) + kehrs
If zb > 360
zb -= 360
mv := RW_LiesParamX(rwt, x, StrLen(rwt), "(MagVar ", "),", 0)
zb += (mv * -1)
z$ .= zb . A_Tab
z$ .= "Grass" . A_Tab . A_Tab . A_Tab . "CT" . A_Tab . "CL" . A_Tab . A_Tab . zlende
}
}
Return z$
}
#Include Lib\Absturz.ahk
