#Include Scr\Header.ahk
Global param := Object()
Global rwys := Object()
comtype0 = Airport Name
comtype1 = ATIS
comtype2 = MULTICOM
comtype3 = UNICOM
comtype4 = CTAF
comtype5 = GROUND
comtype6 = TOWER
comtype7 = CLEARANCE
comtype8 = APPROACH
comtype9 = DEPARTURE
comtype10 = CENTRE
comtype11 = FSS
comtype12 = AWOS
comtype13 = ASOS
comtype14 = CLEARANCE PRE-TAXI
comtype15 = REMOTE CLEARANCE DELIVERY
Global p := Object()
p.ap := 0
p.name := 1
p.lon := 2
p.lat := 3
p.alt := 4
p.ATIS := 5
p.MULTICOM := 6
p.UNICOM := 7
p.CTAF := 8
p.GROUND := 9
p.TOWER := 10
p.CLEARANCE := 11
p.APPROACH := 12
p.DEPARTURE := 13
p.CENTRE := 14
p.FSS := 15
p.AWOS := 16
p.ASOS := 17
p.PRETCLEARANCE := 18
p.DELIVERY := 19
r := Object()
r.ap := 0
r.id := 1
r.len := 2
r.hdg := 3
r.ofl := 4
r.ils := 5
r.dme := 6
r.clt := 7
r.cll := 8
r.lat := 9
r.lon := 10
r.wnkl := 4
r.scor := 5
r.scr2 := 4
r.grou := 6
ap_zeileFrom =
ap_zeileTo =
rw_zeilenF =
rw_zeilenT =
activ = <active>
t = </td><td>
ta = <tr><td>
te = </td></tr>
tafurl = http://www.aviationweather.gov/taf/data?ids=XXXX&format=raw&metars=on&submit=Submit
wetter1 = Schnes Wetter
wetter2 = clear, east wind
wetter3 = clouded, Sdwest
wetter4 = real weather
Ost := 093
Wst := 222
Clm := 0.001
wett1 = clearsky
wett2 = bldstorm
wett3 = cfronts
wett4 = fair
wett5 = foggedin
wett6 = grayrain
wett7 = whiteout
wett8 = tstorm
wett9 = stormy
wett10 = wwonder
wett11 = orbx1
wett12 = orbx2
wett13 = orbx3
wett14 = orbx4
wett15 = orbx5
wett16 = orbx6
foggi := 5
direct1 = North
direct2 = West
direct3 = South
direct4 = East
LowAlt  := 2
HighAlt := 3
VOR     := 1
area_guid = .RectangleArea
zielpf = Data\
ainfobrf = ApInfoBrief.htm
bzbbrf = BZBrief.htm
airports = Airports.csv
runways  = AP_Runways.csv
htmziel = .htm
quell_AP := datapf . airports
quell_Rw := datapf . runways
header := exepfad . "Uires\blank.htm"
header =
( Join`r`n
<HTML>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
<BODY>
</BODY>
</HTML>
)
sids   := datapf . "SIDs.xml"
metardat := apinfopf . "Temp\metar-wetter.html"
ziel := missinfopf . ainfobrf
planinh =
metarinh =
sidinh =
xmlinh =
flightinhalt =
If 0 = 8
{  from_AP = %1%
to_AP = %2%
direction = %3%
auswWetter = %4%
flightdatei = %5%
lati = %6%
longi = %7%                      ; "                 mssen umgerechnet werden
auswFlieger = %8%
If InStr(flightdatei, flightpfad)
mission := 3
Else
mission := 2
ziel := bzbairpf . bzbbrf
zielpf := bzbairpf
}Else If 0 = 6
{  flplan = %1%
auswWetter = %2%
flightdatei = %3%
lati = %4%
longi = %5%
auswFlieger = %6%
mission := 1
ziel := missinfopf . ainfobrf
zielpf := missinfopf
}Else If 0 > 0
Abbruch("wrong number of parameter: " . %0% . " - allowed is 6 or 8")
If auswWetter < 1
{ auswTheme := Abs(auswWetter)
auswWetter := 1
}
IF 0 <= 6
{	If flplan =
{  FileSelectFile, flplan, 3, %planpf%*.PLN, Select Flight Plan, *.pln
IfNotExist, %flplan%
flplan =
}
IfExist, %flplan%
{
afe := A_FileEncoding
FileEncoding, UTF-8
If Dateilesen(planinh, flplan)
Abbruch("unable to open flightplan")
FileEncoding, %afe%
nxtpos := 1
endpos := StrLen(planinh)
from_AP := RW_LiesParamX(planinh, nxtpos, endpos, "<DepartureID>", "<", 0)
to_AP := RW_LiesParamX(planinh, nxtpos, endpos, "<DestinationID>", "<", 0)
If (from_AP = "--" OR to_AP = "--")
flplan =
PlanKopie(planinh, missinfopf)
Loop, 4
{ name := direct%A_Index% . " to"
If InStr(flplan, name, 0, 1)
{ direction := direct%A_Index%
dirnum := A_Index
Break
}
}
}
If (flplan = "" OR flplan = "--")
{ flplan =
InputBox, xyz$, No Flightplan or unknown format, Please enter ICAO for departure and arrival with '-' in between
If xyz$ =
Goto EndeUndAb
StringUpper, xyz$, xyz$
from_AP := SubStr(xyz$, 1, 4)
to_Ap := SubStr(xyz$, InStr(xyz$, "-", 0, 5) +1)
to_Ap := Trim(to_Ap)
}
If !ziel
ziel := zielpf . from_Ap . "-to-" . to_Ap . ".htm"
IfInString, flplan, \Missions\
zielpf = %missinfopf%
}
Gosub Flugz%auswFlieger%
If Dateilesen(flightinhalt, flightdatei)
Abbruch("unable to open flight file: " . flightdatei)
GibGate(flightinhalt, from_AP)
If Dateilesen(ininh, inidat)
Abbruch("unable to open RSC file" . inidat)
If auswWetter = 1
{ xyz := wett%auswTheme%
winddir := RW_LiesParam(ininh, xyz . "=", 1)
}Else
If auswWetter = 2
winddir := Ost
Else
If auswWetter = 3
winddir := Wst
Else
If auswWetter = 4
{ winddir =
StringReplace, tafurl, tafurl, XXXX, %from_Ap%
UrlDownloadToFile, %tafurl%, %metardat%
If Dateilesen(metarinh, metardat)
Abbruch("unable to open Metar data")
nxtpos := InStr(metarinh, "Data at: ")
nxtpos := InStr(metarinh, from_Ap . " ", 1, nxtpos)
endpos := StrLen(metarinh)
wetdat := RW_LiesParamX(metarinh, nxtpos, endpos, "Z ", "KT ", 0)
fehler =
x := StrLen(wetdat)
If (x > 60 OR x < 5)
fehler := True
x := InStr(wetdat, "G")
If x
wetdat := SubStr(wetdat, 1, x-1)
StringRight, xyz, wetdat, 2
If xyz Is Not Integer
fehler := True
x := xyz * 1
If (x < 4)
winddir := Clm
Else
{ x := InStr(wetdat, A_Space, , 0)
If x
wetdat := SubStr(wetdat, x+1)
xyz := SubStr(wetdat, 1, 3)
If xyz Is Not Integer
fehler := True
Else
winddir := xyz * 1
If (winddir > 360 OR winddir < 1 OR winddir = "")
fehler := True
}
If fehler
Abbruch("unknown struktur of Metar file " . metardat . "`nMetar data: " . wetdat)
}
Else
winddir := False
Loop, Read, %quell_Ap%
{ xyz := AP_ErstElem(A_LoopReadLine, A_Tab)
If xyz = %from_AP%
ap_zeileFrom := A_LoopReadLine
If xyz = %to_AP%
ap_zeileTo := A_LoopReadLine
If (ap_zeileFrom AND ap_zeileTo)
Break
}
fehler =
If ap_zeileFrom =
fehler = kein departure Airport gefund
If ap_zeileTo =
fehler = kein destination Airport gefund
If fehler
Abbruch(fehler)
fromzlr := 0
tozlr := 0
Loop, Read, %quell_Rw%
{
xyz := AP_ErstElem(A_LoopReadLine, A_Tab)
If xyz = %from_AP%
{
rw_zeilenF .= A_LoopReadLine . zlende   ; oder "#" ???
fromzlr = 1
}
Else
{
If fromzlr
fromzlr = 10
}
If xyz = %to_AP%
{
rw_zeilenT .= A_LoopReadLine . zlende   ; oder "#" ???
tozlr = 1
}
Else
{
If tozlr
tozlr = 10
}
x := fromzlr+tozlr
If (fromzlr = 10 AND tozlr = 10)
Break
}
x := InStr(header, "<Body>") -1
StringLeft, header, header, x
IfExist, %ziel%
FileDelete, %ziel%
FileAppend %header%, %ziel%
If errorlevel
Abbruch("unable to create " . ziel . "Errornumber: " .  A_LastError)
header =
(
<head>
<title>Airport Information</title>
</head>
<body>
<P><font face="Arial" style="font-size: 14pt"><B><U>Airport Information</U></B></font><BR> </P>

<!------------------------- Departure ------------------------------>
<P><font face="Arial" style="font-size: 11pt"><B><U>Departure</U></B></font><BR></P>
<P> <!------ Airport ------->
<table border="1" cellpadding="4" cellspacing="0" font face="Arial" style="font-size: 9pt"
style="border-collapse: collapse" bordercolor="#C0C0C0" width="378" id="AutoNumber1">

<tr><td width="220"><b>Airport</td> <td width="90" align=center><b>ICAO</b></td> <td width="90" align=center><b>Alt</b></td> <td width="90" align=center><b>ATIS</b></td> <td width="90" align=center><b>Ground</b></td> <td width="90" align=center><b>Tower</b></td> <td width="90" align=center><b>Clearance</b></td> </tr>
)
FileAppend %header%, %ziel%
ResetParam()
count := SetParam(ap_zeileFrom)
SuchComm()
ap_zeileFrom := ta . param[1] . t . param[0] . t . param[p.alt] . t
ap_zeileFrom .= param[p.atis] . t . param[p.ground] . t . param[p.tower] . t . param[p.clearance] . te . zlende
longfrom := param[p.lon]
latifrom := param[p.lat]
altfrom := param[p.alt]
namefrom := param[p.name]
FileAppend, %ap_zeileFrom%, %ziel%
ResetParam()
count := SetParam(ap_zeileTo)
SuchComm()
ap_zeileTo := ta . param[1] . t . param[0] . t . param[p.alt] . t
ap_zeileTo .= param[p.atis] . t . param[p.ground] . t . param[p.tower] . t . param[p.approach] . te . zlende
name_to := param[p.name]
If (direction = "" OR direction = "nodir")
{ dirnum := KalcDir(longfrom, latifrom, param[p.lon], param[p.lat])
direction := direct%dirnum%
}
header =
(
</table> </P>
<P> <!------ Runways ------->
<table border="1" cellpadding="4" cellspacing="0" font face="Arial" style="font-size: 9pt"
style="border-collapse: collapse" bordercolor="#C0C0C0" width="378" id="AutoNumber1">
<tr><td width="90"><b>Rwy-ID</td> <td width="90" align=center><b>Hdg</b></td> <td width="90" align=center><b>Len (ft)</b></td> <td width="90" align=center><b>Surface</b></td> <td width="110" align=center><b>ILS</b></td> <td width="90" align=center><b>DME</b></td> <td align=center> <b>Closed</b></td> </tr>
)
FileAppend %header%, %ziel%
rwzl := 0
Loop, Parse, rw_zeilenF, `n, `r
{
ResetParam()
If A_LoopField =
Break
count := SetParam(A_LoopField)
xyz := param[r.id]
If (StrLen(xyz) = 1)
xyz := FillNull(xyz)
rw_zeile := ta . xyz . t
xyz := Round(param[r.hdg], 1)
If (param[r.len] > 999)
{ rw_zeile .= xyz . t . param[r.len] . t . param[r.ofl] . t . param[r.ils] . t . param[r.dme]
If param[r.clt] = "CT"
rw_zeile .= t . "Closed" . te . zlende
Else
{
rw_zeile .= te . zlende
}
FileAppend, %rw_zeile%, %ziel%
}
rwzl += 1
rwys[rwzl] := param.Clone()
}
header := "</table> </P> " . zlende . "<P><font face=" . quote . "Arial" . quote . " style=" . quote . "font-size: 10pt" . quote . ">" . zlende
FileAppend %header%, %ziel%
x := 1
Loop
{ If (rwys[x, r.hdg] > rwys[x+1, r.hdg])
{ rwys[0]   := rwys[x+1]
rwys[x+1] := rwys[x]
rwys[x]   := rwys[0]
x:= 0
}
x += 1
If (x = rwzl)
Break
}
lengst := 1
Loop, %rwzl%
{ If (rwys[A_Index, r.ils] = "")
{ rwys[A_Index, r.scor] := -50
}Else
rwys[A_Index, r.scor] := 0
If winddir > 0
{ x := rwys[A_Index, r.hdg]
x -= winddir
rwys[A_Index, r.wnkl] := Ceil(Abs(x))
}
If (rwys[A_Index, r.len] > lengst)
lengst := rwys[A_Index, r.len]
}
lengst := lengst / 100 * 70
gr := 1
Loop, %rwzl%
{ If A_Index > 1
{ If (ABS(rwys[A_Index, r.hdg] - rwys[A_Index-1, r.hdg]) >= 8)
{	gr += 1
}
}
rwys[A_Index, r.grou] := gr
If (rwys[A_Index, r.len] >= lengst)
rwys[A_Index, r.scor] += 50
If (rwys[A_Index, r.wnkl] >= 90)
rwys[A_Index, r.scor] -= winddir
Else
rwys[A_Index, r.scor] += winddir
If winddir > 0
rwys[A_Index, r.scor] -= rwys[A_Index, r.wnkl]
If (rwys[A_Index, r.clt] = "")
rwys[A_Index, r.scor] += 100
If (rwys[A_Index, r.cll] = "")
rwys[A_Index, r.scor] += 100
}
gr := 0
If Dateilesen(sidinh, sids)
Abbruch("unable to open SIDs.xml")
nxtpos := InStr(sidinh, "<GNDImg>" . to_Ap, 1, 1)
If nxtpos
{  endpos := StrLen(sidinh)
gndimg := RW_LiesParamX(sidinh, nxtpos, endpos, "<GNDImg>", "</GNDImg>", 1)
}Else
gndimg = --
x := InStr(sidinh, "<Ap>" . from_Ap, 1, 1)
If x
{ y := InStr(sidinh, "</Ap>", 0, x+2)
sidinh := SubStr(sidinh, x, y-x)
}
Else
{ rw_zeile =
Goto NoSid
}
rpos := 0
Loop
{
rpos := InStr(sidinh, "<Ry>", 0, rpos+1)
If !rpos
Break
y := InStr(sidinh, zlende, 0, rpos+1)
xyz := SubStr(sidinh, rpos+4, y-rpos-4)             ; die Zeile "<Ry..." ausschneiden
If winddir = 0
{ IfInString, xyz, %activ%
{ xyz := Trim(SubStr(xyz, 1, InStr(xyz, "<") - 1))
rwys[SidPos(xyz, r.id), r.scor] += 50
}
}
}
declati := AP_LaLoToDez(lati)
declongi := AP_LaLoToDez(longi)
hd := 0.1
Loop, %rwzl%
{ If (rwys[A_Index, r.lat] = "")
rwys[A_Index, r.scr2] := 100
Else
{ difflon := (declongi - rwys[A_Index, r.lon]) / 360
circ := 40075017 * Cos(rwys[A_Index, r.lat] * 0.01745329252)
ow := difflon * circ
difflat := (declati - rwys[A_Index, r.lat]) / 360
ns := 40007863 * difflat
hd := rwys[A_Index, r.hdg] * 0.01745329252
rwys[A_Index, r.scr2] := Abs( (Sin(hd) * ns) - (Cos(hd) * ow) )
}
If (rwys[A_Index, r.clt] = "CT")
rwys[A_Index, r.scr2] *= 10000
If (enginetype = 0)
enginetype := 2500
Else
If (enginetype = 1)
{	If (emptyw = 0)
enginetype := 5000
Else
{ enginetype = ((emptyw - 10000) * 2000 / 90000 ) + 5000
If (enginetype > 7000)
enginetype := 7000
If (enginetype < 5000)
enginetype := 5000
}
}Else
enginetype := 4000
If (rwys[A_Index, r.len] < enginetype)
rwys[A_Index, r.scr2] *= 10000
}
If (gr = 0)
{ score := -100000000
gr := 1
Loop, %rwzl%
{	If (rwys[A_Index, r.scor] > score)
{ gr := rwys[A_Index, r.grou]
score := rwys[A_Index, r.scor]
}
}
}
If (gr = 0)
{ rw_zeile =
Goto NoSid
}
rwid =
score := 100000000
Loop, %rwzl%
{ If (rwys[A_Index, r.grou] = gr)
If (rwys[A_Index, r.scr2] < score)
{ score := rwys[A_Index, r.scr2]
rwid := rwys[A_Index, r.id]
}
}
If auswTheme = %foggi%
{  xyz := rwid
If xyz IS Not number
{ StringRight, z, xyz, 1
xyz := SubStr(xyz, 1, StrLen(xyz)-1)
If z = L
z := "R"
Else If z = R
z := "L"
}
xyz *= 10
If xyz > 180
xyz -= 180
Else
xyz += 180
xyz /= 10
rwid := xyz . z
}
rw_zeile := "gewhlte Gruppe: " . gr . "`n gewhlte Runway: " . rwid . " Scores: " . zlende
rw_zeile .= "Flgz-Pos Lat: " . declati . " Lon: " . declongi . zlende
xyz := RwTestPrint(0)
rw_zeile .= "  wdir: " . winddir xyz
clipboard := rw_zeile
dirdir =
rw_zeile = <B>
nxtpos := 1
endpos := StrLen(sidinh)
sidinh := RW_LiesParamX(sidinh, nxtpos, endpos, "<Ry>" . rwid, "</Ry>", 1)
z := InStr(sidinh, "<to>" . to_AP)       ; hier testen auf "<to>%to_Ap%" und evtl dir neu setzen
If z
{ z := InStr(sidinh, "DIR>", 0, z - StrLen(sidinh))
direction := Trim(SubStr(sidinh, z+4, 5))
}
IfInString, sidinh, %direction%
{  nxtpos := 1
endpos := StrLen(sidinh)
dirdir := RW_LiesParamX(sidinh, nxtpos, endpos, "<Dir>" . direction, "</Dir>", 1)
z := InStr(dirdir, zlende)
dirdir := SubStr(dirdir, z+2)
x := 1
y := InStr(dirdir, "<WP>")
If y
{ waypoint := RW_LiesParamX(dirdir, x, StrLen(dirdir), "<WP>", "</WP>", 1)
w := InStr(waypoint, "=")
If w
{ waypname := SubStr(waypoint, 1, w-1)
waypoint := SubStr(waypoint, w+1)
}Else
waypoint =
dirdir := SubStr(dirdir, 1, y-1)
}
x := 1
y := InStr(dirdir, "<Img>")
If y
{ y -= 1
x := y
sidabb := RW_LiesParamX(dirdir, x, StrLen(dirdir), "<Img>", "</Img>", 1)
dirdir := SubStr(dirdir, 1, y)
}
dirdir := "Rwy " . rwid . " " . direction . " " . dirdir
}
If dirdir
{ dirfuerfpl := StrReplace(dirdir, "<b>", "<")
dirfuerfpl := StrReplace(dirfuerfpl, "</B>", ">")
x := 1
wphoehe := RW_LiesParamX(dirfuerfpl, x, StrLen(dirfuerfpl), "<sup>", "</sup>", 0)
dirfuerfpl := StrReplace(dirfuerfpl, "<sup>", "<")
dirfuerfpl := StrReplace(dirfuerfpl, "</sup>", ">")
StringReplace, dirdir, dirdir, %zlende%, <BR>%zlende%, All
StringReplace, dirdir, dirdir, <BR>, </B><BR>
rw_zeile .= dirdir . "<BR>" . zlende
If sidabb =
{ x := InStr(sidinh, "<Img>")
While InStr(sidinh, "</Dir>", 0, x)
{ x := InStr(sidinh, "<Img>", 0, x+1)
}
sidabb := RW_LiesParamX(sidinh, x, StrLen(sidinh), "<Img>", "</Img>", 1)
}
If (sidabb <> "--")
rw_zeile .= "<img src=" . quote . "../images/" . sidabb . quote . "> <BR><BR></p>" . zlende
}
If (InStr(waypoint,"") = 0)
{ rix := SidPos(rwid, r.id)
waypoint := AP_DezToLaLo(rwys[rix,r.lat],rwys[rix,r.lon])
waypoint .= Alt6(altfrom-30)
}Else
{ x := InStr(waypoint, ",", 1, 0)
xyz := SubStr(waypoint, x+1)
If xyz =
xyz := altfrom - Mod(altfrom,1000) +3000
waypoint := SubStr(waypoint, 1, x-1) . Alt6(xyz-500)
}
StringReplace, xmlname, flightdatei, %flight_ext%, .XML
IfNotExist, %xmlname%
{ StringReplace, spbname, flightdatei, %flight_ext%, .SPB
IfExist, %spbname%
{ Runwait, spb2xml.exe -s "%exepfad%propdefs" "%spbname%", , Hide
FileMove, %spbname%, %spbname%Bak
SplitPath, xmlname, spbname, xyz, , x
spbname := xyz . "\" . x . "_profile.xml"
If Dateilesen(varinh, spbname)
Abbruch("unable to open " . spbname)
x := 1
tcounter := SubStr(RW_LiesParamX(varinh, x, StrLen(varinh), "value=" . quote, quote . "/>", 0) ,  1,1)
}Else
Abbruch("no mission XML/SPB file exist")
}
afe := A_FileEncoding
IfInString, flightdatei, %bzbrelpf%
FileEncoding, UTF-8
Else
FileEncoding, CP1252
If Dateilesen(xmlinh, xmlname)
Abbruch("unable to open " . xmlname)
If tcounter
{
x := InStr(xmlinh, ">CT_Save_" . tcounter . "<")
If !x
x := InStr(xmlinh, "<ResumeExecution>true<") -10
If x > 0
xmlinh := StrReplace(xmlinh, "<ResumeExecution>true<", "<ResumeExecution>false<", 1)
}
If mission > 1
{ RW_SetzXmlParam(xmlinh, area_guid, "<WorldPosition>", waypoint, "</")
If mission = 3
{ Random, z, 1, 8
RW_SetzXmlParam(xmlinh, "", "G1BBoardingOK_", z, ".wav<")
Random, z, 1, 8
RW_SetzXmlParam(xmlinh, "", "G2aNextStation_", z, ".wav<")
Random, z, 1, 6
RW_SetzXmlParam(xmlinh, "", "G2bNextAbflug_", z, ".wav<")
Random, z, 1, 4
RW_SetzXmlParam(xmlinh, "", ">Now_ATC_", z, ".wav<")
y := 1
x := RW_LiesParamX(xmlinh, y, StrLen(xmlinh), "<Length>", "</Length>", 1)
x += RW_LiesParamX(xmlinh, y, StrLen(xmlinh), "<Width>", "</Width>", 1)
If x < 4000
MsgBox, RectangleArea kleiner als 2000x2000m
}
}
FileDelete, %xmlname%
FileAppend %xmlinh%, %xmlname%
If Errorlevel
Abbruch("Error writing " . xmlname)
FileEncoding, %afe%
flyplan_stddir := RW_LiesParam(ininh, "flyplandir=", 1)
While planinh = ""
{
If mission = 1
{ fplpf := missinfopf
planinh := SuchFPlan(from_AP, to_AP, "", rwid, fplpf)
}Else
{ If mission = 3
fplpf := flightpfad
Else
fplpf := bzbairpf
planinh := SuchFPlan(from_AP, to_AP, waypname, rwid, fplpf)
}
If (SubStr(fplpf, StrLen(fplpf),1) <> "\")
fplpf .= "\"
If planinh =
{ planinh := SuchFPlan(from_AP, to_AP, waypname, rwid, flyplan_stddir)
If (planinh <> "")
PlanKopie(planinh, fplpf)
}
If planinh =
{ prgpfad := RW_LiesParam(ininh, "prgpfad5=", 1)
prgname := RW_LiesParam(ininh, "prgname5=", 1)
program := RW_LiesParam(ininh, "program5=", 1)
If (program = 1 AND FileExist(prgpfad . prgname))
{ CoordMode, ToolTip, Screen
ToolTip, Fly %from_AP% to %to_AP%`n%dirfuerfpl%, A_ScreenWidth-(A_ScreenWidth/4), 10
RunWait, %prgpfad%%prgname%
ToolTip
planinh := SuchFPlan(from_AP, to_AP, waypname, rwid, flyplan_stddir)
If (planinh <> "")
PlanKopie(planinh, fplpf)
If (planinh = "")
{ MsgBox, 36, No suitable Flight Plan, Did you forget to include starting point (runway) or waypoint? Do you want to continue without flight plan?
IfMsgBox, Yes
Break
}
}Else
Break
}
}
x := RW_InStr(flightinhalt, "[ATC_Aircraft.0]", 0,1)
If (planinh AND x)
{ RW_SetzParam(flightinhalt, x, "RequestedFlightPlan=", "True", 0)
xyz := fplan_inFlt
If p3dxml
xyz := fplan_inFxml
If Dateilesen(fpleinsatz, xyz)
Abbruch("unable to open " . xyz)
xd := 1
xl := StrLen(planinh)
RW_SetzParam(fpleinsatz, 1, "title=", RW_LiesParamX(planinh, xd, xl, "<Title>", "</Title>", 0), 0)
If !p3dxml
RW_SetzParam(fpleinsatz, 1, "description=", from_AP . ", " . to_AP, 0)
If !InStr(planinh, "<RouteType>")
xyz = 0
Else
{ xyz := RW_LiesParamX(planinh, xd, xl, "<RouteType>", "</RouteType>", 0)
xyz := %xyz%
}
RW_SetzParam(fpleinsatz, 1, "routetype=", xyz, 0)
cruisalt := RW_LiesParamX(planinh, xd, xl, "<CruisingAlt>", "</CruisingAlt>", 0)
If (SubStr(wphoehe, 1,2) = "fl")
wphoehe := SubStr(wphoehe, 3) * 100
If (cruisalt < wphoehe)
cruisalt := wphoehe
RW_SetzParam(fpleinsatz, 1, "cruising_altitude=", cruisalt, 0)
xid := RW_LiesParamX(planinh, xd, xl, "<DepartureID>", "</DepartureID>", 0) . ", "
xyz := RW_LiesParamX(planinh, xd, xl, "<DepartureLLA>", "</DepartureLLA>", 0)
xid .= IDPosKoord(xyz)
RW_SetzParam(fpleinsatz, 1, "departure_id=", xid, 0)
RW_SetzParam(fpleinsatz, 1, "departure_position=", rwid, 0)
xid := RW_LiesParamX(planinh, xd, xl, "<DestinationID>", "</DestinationID>", 0) . ", "
xyz := RW_LiesParamX(planinh, xd, xl, "<DestinationLLA>", "</DestinationLLA>", 0)
xid .= IDPosKoord(xyz)
RW_SetzParam(fpleinsatz, 1, "destination_id=", xid, 0)
RW_SetzParam(fpleinsatz, 1, "departure_name=", namefrom, 0)
RW_SetzParam(fpleinsatz, 1, "destination_name=", name_to, 0)
If p3dxml
{ zeile = <Property Name="waypoint.#" Value="      ;, EDDV, , EDDV, A, 0 0, 0 0, 0," />
zeile := "            " . zeile
}Else
zeile = waypoint.#=
blck =
xl := InStr(planinh, "</ATCWaypoint>", 0, xd)
derwp =
Loop
{ z =
If xl = 0
Break
xid := RW_LiesParamX(planinh, xd, xl, "<ATCWaypoint id=" . quote, quote . ">", 0)
If (xid = "--")
Break
xtp := RW_LiesParamX(planinh, xd, xl, "<ATCWaypointType>", "</ATCWaypointType>", 0)
xwp := RW_LiesParamX(planinh, xd, xl, "<WorldPosition>", "</WorldPosition>", 0)
If (xtp <> "Airport")
z := RW_LiesParamX(planinh, xd, xl, "<ICAORegion>", "</ICAORegion>", 0)
wid := RW_LiesParamX(planinh, xd, xl, "<ICAOIdent>", "</ICAOIdent>", 0)
z .= ", " . xid . ", , " . wid . ", " . SubStr(xtp,1,1) . ", "
x := InStr(xwp, ",", 0, -1)
If x
{ xwp := SubStr(xwp, 1, x-1)
If (waypname = wid)
{ xwp .= Alt6(wphoehe)
derwp := True
}Else
{ If (derwp AND xtp <> "Airport")
xwp .= Alt6(cruisalt)
}
}
wphh%A_Index% := xwp
z .= IDPosKoord(xwp) . ","
wpnr := A_Index-1
blck .= StrReplace(zeile, "#", wpnr) . z
If p3dxml
blck .= quote . " />"
blck .= zlende
xl := InStr(planinh, "</ATCWaypoint>", 0, xl+10)
}
wpnr += 1
If p3dxml
{ x := InStr(fpleinsatz, "</Section>")
x := InStr(fpleinsatz, zlende, 0, x-StrLen(fpleinsatz) )
}Else
x := InStr(fpleinsatz, "`r`n`r`n")
fpleinsatz := SubStr(fpleinsatz, 1, x+1) . blck . SubStr(fpleinsatz, x+2)
xd := 1
xl := StrLen(planinh)
SplitPath, flightdatei, , xyz, , xid
RW_SetzParam(fpleinsatz, 1, "Filename=", xyz . "\" . xid , 0)
xyz := RW_LiesParamX(planinh, xd, xl, "<DepartureLLA>", "</DepartureLLA>", 0)
RW_SetzParam(fpleinsatz, 1, "position=", IDPosKoord(xyz), 0)
RW_SetzParam(fpleinsatz, 1, "CountWP=", wpnr, 0)
If p3dxml
{ zeile = <Property Name="WpInfo#" Value="               ;180, 0, 55, 0, 0, 0.0, 0.0, 0.0" />
zeile := "            " . zeile
}Else
zeile = WpInfo#=
blck =
Loop, %wpnr%
{
hh := wphh%A_Index%
lar := StrSplit(hh, ",", "+ -0")
hh := lar[3]
hh := Round(hh * 0.3048)
z := zeile . cruispd . ", 0, " . hh . ", 0, 0, 0.0, 0.0, 0.0"
nr := A_Index-1
blck .= StrReplace(z, "#", nr)
If p3dxml
blck .= quote . " />"
blck .= zlende
}
If p3dxml
{ x := InStr(fpleinsatz, "PlaneStarted")
x := InStr(fpleinsatz, zlende, 0, x)+2
}Else
x := InStr(fpleinsatz, "CountFP=")
fpleinsatz := SubStr(fpleinsatz, 1, x-1) . blck . SubStr(fpleinsatz, x)
z = ,00000000,00000000,00000000,00000000,00000000,00000000
lar := StrSplit(wphh1, ",")
x := 128 * ( AP_LaLoToDez(lar[1]) * (10001750 / 90) )
y := AP_LaLoToDez(lar[2]) * ( (65536.0/360.0) * 65536.0)
x := "0000000" . Format("{:x}", x )
y := "0000000" . Format("{:x}", y )
z := SubStr(x, StrLen(x)-7, 8) . "," . SubStr(y, StrLen(y)-7, 8) . z
RW_SetzParam(fpleinsatz, 1, "FP0=", z, 0)
x := EntFerne(flightinhalt, "[GPS_Engine]")
x := EntFerne(flightinhalt, "[ATC_RequestedFlightPlan.0]")
If !x
{ x := RW_InStr(flightinhalt, "[ATC_Aircraft.0]", 0,1)
If p3dxml
x := InStr(flightinhalt, "<Section Name=", 0, x+10)
Else
x := InStr(flightinhalt, "[", 0, x+1)
x := InStr(flightinhalt, zlende, 0, x-StrLen(flightinhalt))
}
If p3dxml
fpleinsatz := SubStr(fpleinsatz, InStr(fpleinsatz, zlende)+2)    ;  dann erste Zeile abschneiden (Type="ScenarioFile")
Else
fpleinsatz .= zlende
flightinhalt := SubStr(flightinhalt, 1, x+1) . fpleinsatz . SubStr(flightinhalt, x+2)
}
NoSid:
If flightinhalt
{ altfrom += 3.5 + (passenger / 30)
If altfrom > 0
altfrom := "+" . altfrom
Else
altfrom := "-" . altfrom
x := RW_InStr(flightinhalt, "[SimVars.", 0,1)
RW_SetzParam(flightinhalt, x, "Altitude=", altfrom, 0)
If p3dxml
{ SplitPath, flightdatei, , , , fname
RW_SetzXmlParam(flightinhalt, scefiletyp, "id=" . quote, fname, quote . ">")
RW_SetzXmlParam(flightinhalt, "", "<Filename>", fname . flight_ext, "</Filename>")
}
afe := A_FileEncoding
If p3d
FileEncoding, UTF-8
IfExist, %flightdatei%
FileDelete, %flightdatei%
FileAppend, %flightinhalt%, %flightdatei%
FileEncoding, %afe%
}
If (rw_zeile = "" OR rw_zeile = "<B>")
rw_zeile := "Kein SID fr diese(n) Airport/Runway vorhanden</B></p>" . zlende
FileAppend, %rw_zeile%, %ziel%
header =
(
<!------------------------- Arrival ------------------------------>
<P><font face="Arial" style="font-size: 11pt"><B><U>Arrival</U></B></font><BR></P>

<P> <!------ Airport ------->
<table border="1" cellpadding="4" cellspacing="0" font face="Arial" style="font-size: 9pt"
style="border-collapse: collapse" bordercolor="#C0C0C0" width="378" id="AutoNumber1">

<tr><td width="220"><b>Airport</td> <td width="90" align=center><b>ICAO</b></td> <td width="90" align=center><b>Alt</b></td> <td width="90" align=center><b>ATIS</b></td> <td width="90" align=center><b>Ground</b></td> <td width="90" align=center><b>Tower</b></td> <td width="90" align=center><b>Approach</b></td> </tr>
)
FileAppend %header%, %ziel%
FileAppend, %ap_zeileTo%, %ziel%
header =
(
</table> </P>

<P> <!------ Runways ------->
<table border="1" cellpadding="4" cellspacing="0" font face="Arial" style="font-size: 9pt"
style="border-collapse: collapse" bordercolor="#C0C0C0" width="378" id="AutoNumber1">
<tr><td width="90"><b>Rwy-ID</td> <td width="90" align=center><b>Hdg</b></td> <td width="90" align=center><b>Len</b></td> <td width="90" align=center><b>Surface</b></td> <td width="90" align=center><b>ILS</b></td> <td width="90" align=center><b>DME</b></td> </tr>
)
FileAppend %header%, %ziel%
Loop, Parse, rw_zeilenT, `n, `r
{
ResetParam()
If A_LoopField =
Break
count := SetParam(A_LoopField)
If (param[r.len] > 999)
{ xyz := param[r.id]
If (StrLen(xyz) = 1)
xyz := FillNull(xyz)
rw_zeile := ta . xyz . t
xyz := Round(param[r.hdg], 1)
rw_zeile .= xyz . t . param[r.len] . t . param[r.ofl] . t . param[r.ils] . t . param[r.dme]
If param[r.cll] = "CL"
rw_zeile .= t . "Closed" . te . zlende
Else
rw_zeile .= te . zlende
FileAppend, %rw_zeile%, %ziel%
}
}
header =
(
</table> </P>
)
FileAppend %header%, %ziel%
If (gndimg <> "--")
{	 header = <img src=%quote%../images/%gndimg%%quote%> <BR><BR>%zlende%
FileAppend %header%, %ziel%
}
header =
(
</body></html>
)
FileAppend %header%, %ziel%
If !1
MsgBox, Airports&Runways saved in %ziel%
GuiClose:
EndeundAb:
planinh =
metarinh =
sidinh =
xmlinh =
ininh =
ExitApp
#Include %A_AppData%\KneeboardTools\BZB-Qickstarter\Routen.inc
SuchFPlan(from_AP, to_AP, waypname, runway, flyplandir)
{ runway := LTrim(runway, "0 ")
Loop, %flyplandir%*.PLN, , 1
{ afe := A_FileEncoding
FileEncoding, UTF-8
FileRead, planinh, %flyplandir%%A_LoopFileName%
FileEncoding, %afe%
y := 1
tstfrom := RW_LiesParamX(planinh, y, StrLen(planinh), "<DepartureID>", "<", 0)
y := 1
tstto   := RW_LiesParamX(planinh, y, StrLen(planinh), "<DestinationID>", "<", 0)
y := 1
tstrwid := RW_LiesParamX(planinh, y, StrLen(planinh), "<DeparturePosition>", "<", 0)
If (tstfrom = from_AP AND tstto = to_AP AND tstrwid = runway AND SuchWP(planinh, waypname, from_AP))
Break
Else
planinh =
}
Return planinh
}
SuchWP(ByRef planinh, testwp, fromap)
{ If (testwp = "")
Return True
x := InStr(planinh, "<ICAOIdent>" . fromap . "</")
Loop
{ tst := RW_LiesParamX(planinh, x, StrLen(planinh), "<ICAOIdent>", "</ICAOIdent>", 0)
If (tst = "--")
Break
If (tst = testwp)
Return True
}
Return False
}
PlanKopie(ByRef planinh, plpfad)
{ Global flightdatei
SplitPath, flightdatei, , , , fname
fname .= ".PLN"
If FileExist(plpfad . fname)
FileDelete, %plpfad%%fname%
afe := A_FileEncoding
FileEncoding, UTF-8
FileAppend, %planinh%, %plpfad%%fname%
FileEncoding, %afe%
If Errorlevel
MsgBox, Warning! Error while writing flightplan to %fplpf%
Return
}
IDPosKoord(kooz)
{ kteile := StrSplit(kooz, ",")
rueck := GMStoHalbDez(kteile[1]) . ", "
rueck .= GMStoHalbDez(kteile[2]) . ", " . kteile[3]
Return rueck
}
GMStoHalbDez(koo)
{ larr := StrSplit(koo, " ", "'" . quote)
rueck := larr[1] . " "
rueck .= Round( larr[2] + (larr[3] / 60) , 2) . "'"
If p3dxml
{ rueck := StrReplace(rueck, "", "&#xB0;")
rueck := StrReplace(rueck, "'", "&apos;")
}
Return rueck
}
EntFerne(ByRef finhalt, pname)
{ y = , xz =
x := RW_InStr(finhalt, pname, 0,1)
If !x
Return x
xz := InStr(finhalt, zlende, 0, x-StrLen(finhalt))
If xz =
xz := 1
If p3dxml
y := InStr(finhalt, "<Section Name=", 0, x+10)
Else
y := InStr(finhalt, "[", 0, x+10)
y := InStr(finhalt, zlende, 0, y-StrLen(finhalt))
finhalt := SubStr(finhalt, 1, xz+1) . SubStr(finhalt, y+2)
Return xz
}
SidPos(rwid, id)
{ Loop
{ If (rwys[A_Index, id] = rwid)
{ nr := A_Index
Break
}
If A_Index > 25
Break
}
Return nr
}
Alt6(alt)
{ xyz := "00000" . Floor(alt)
StringRight, xyz, xyz, 6
If alt < 0
wp := ",-"
Else
wp := ",+"
wp .= xyz . ".00"
Return wp
}
SetParam(z$)
{
Loop, Parse, z$, %A_Tab%
{
x := A_Index - 1
StringReplace, xyz, A_LoopField, |, <BR>, All
param[x] := xyz
}
Return x+1
}
ResetParam( )
{
param[0] =
Loop, 19
{
param[A_Index] =
}
Return
}
SuchComm()
{
If (param[p.tower] = "")
If (param[p.tower] <> "")
param[p.tower] := "FSS:<BR>" . param[p.fss]
Return
}
KalcDir(lonS, latS, lonZ, latZ)
{ lonlat := lonS-lonZ
lonlat := Abs(lonlat) / 2
latlon := latS-latZ
latlon := Abs(latlon)
If lonlat > %latlon%
{ If lonZ > %lonS%
Return 4                  ; "East"
Else
Return 2                  ; "West"
}
Else
{ If latZ > %latS%
Return 1
Else
Return 3
}
}
#Include Lib\Absturz.ahk
RwTestPrint(offs)
{ Global r
Loop
{
If (rwys[A_Index +offs, r.id] = "")
Break
z$ .= A_Index+offs . ": " . rwys[A_Index +offs, r.id] . "`tgr:" . rwys[A_Index +offs, r.grou] . "`tw/scr2: " . Round(rwys[A_Index +offs, r.wnkl],4) . "`ts: " . rwys[A_Index +offs, r.scor] . zlende
}
Return z$
}
