﻿/* Resource for building Routen.ini 
   Aircraft data and routes
   for Home airport EDDV
*/

;=Airplane0:          [...]
enginetype  := 0            ; Engine-Type: 0 = Piston
emptyweight := ????         ; in lbs (as in aircraft.cfg)
payloadG    := ?            ; Payload Baggage in kg
payloadS    := ?            ; Payload Cargo in kg
passenger   := ?            ; Passengers
bzb_range   := ???          ; max range nm, lenght of stages will be calculated 
cruispd     := ???          ; Cruise Speed, kts 
stations     = ?            ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := ?            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := ?            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := ?            ; front baggage
pasperstat  := ?            ; passengers per station
statperrow  := ?            ; stations per row - normally 1 or 2 = 4 Passg; bigger airplanes not supported
aftbags     := ?            ; Rear Bags - max kg
aftcargo    := ?            ; Rear Cargo, always the last
atcID        = ?            ; The name that ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-HOME
routezl = 1                ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane1:          Cessna Skyhawk
enginetype  := 0            ; Engine-Type: 0 = Piston
emptyweight := 1650         ; in lbs (as in aircraft.cfg)
payloadG    := 30           ; Payload Baggage in kg
payloadS    := 100          ; Payload Cargo in kg
passenger   := 3            ; Passengers
bzb_range   := 635          ; max range nm, lenght of stages will be calculated 
cruispd     := 124          ; Cruise Speed, kts 
stations     = -5           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 1            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service/ Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 4            ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-ExBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVC-EDVS-HOME
route2  = Route:HOME-EDVH-EDVY-HOME
route3  = Route:HOME-EDVS-EDVC-HOME
route4  = Route:HOME-EDVM-EDVS-HOME
route5  = Route:HOME-EDVR-EDVY-EDVH-HOME
route6  = Route:HOME-EDXI-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDVS-HOME
route9  = Route:HOME-EDVC-EDVM-HOME
route10 = Route:HOME-EDVR-HOME
routezl = 10                ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane2:           Mooney Bravo
enginetype  := 0            ; Engine-Type: Piston
emptyweight := 2189         ; in lbs (as in aircraft.cfg)
payloadG    := 30           ; Payload Baggage in kg
payloadS    := 200          ; Payload Cargo in kg
passenger   := 3            ; Passengers
bzb_range   := 1000         ; max range nm, lenght of stages will be calculated 
cruispd     := 195          ; Cruise Speed, kts 
stations     = -5           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 1            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 4            ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-ExBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDVW-EDVS-HOME
route3  = Route:HOME-EDDW-EDXI-HOME
route4  = Route:HOME-EDVS-EDVW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDXI-EDDW-EDVH-HOME
route9  = Route:HOME-EDVW-EDVY-HOME
route10 = Route:HOME-EDVR-EDLP-EDVW-HOME
route11 = Route:HOME-EDVW-EDLP-EDVY-HOME
routezl = 11                  ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane3:            Beech Baron
enginetype  := 0            ; Engine-Type: Piston
emptyweight := 3911         ; in lbs (as in aircraft.cfg)
payloadG    := 60           ; Payload Baggage in kg
payloadS    := 200          ; Payload Cargo in kg
passenger   := 5            ; Passengers (with 1 Pilot)
bzb_range   := 1500         ; max range nm, lenght of stages will be calculated 
cruispd     := 200          ; Cruise Speed, kts 
stations     = -7           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 60           ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-IxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDLP-EDLW-EDDG-HOME
route3  = Route:HOME-EDDW-EDVY-HOME
route4  = Route:HOME-EDDG-EDDW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDDG-HOME
route9  = Direction:West Route:HOME-EDDG-HOME
route10 = Route:HOME-EDLW-HOME
route11 = Route:HOME-EDLW-EDDG-HOME
route12 = Route:HOME-EDVR-EDLP-EDVW-HOME
route13 = Route:HOME-EDDW-EDDG-EDLP-HOME
route14 = Route:HOME-EDDW-EDDG-EDLP-HOME
routezl = 14                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane4:         Mitsubishi MU-2
enginetype  := 5            ; Engine-Type: 5 = Turboprop
emptyweight := 5430         ; in lbs (as in aircraft.cfg)
payloadG    := 80           ; Payload Baggage in kg
payloadS    := 60           ; Payload Cargo in kg
passenger   := 5            ; Passengers (with 1 Pilot)
bzb_range   := 1200         ; max range nm, lenght of stages will be calculated 
cruispd     := 240          ; Cruise Speed, kts 
stations     = 7            ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 6            ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-IxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDLV-HOME
route2 = Direction:West   Route:HOME-EDLW-EDDL-HOME
route3 = Direction:West   Route:HOME-EDDL-EDDW-HOME
route4 =                  Route:HOME-EDDB-EDDP-EDVK-HOME
route5 = Direction:South  Route:HOME-EDDK-EDDS-EDDP-EDDB-HOME
route6 = Direction:West   Route:HOME-EDDG-EDDK-EDDL-HOME
route7 = Direction:East   Route:HOME-EDDB-EDDH-EDDG-HOME
route8 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route9 =                  Route:HOME-EDDK-EBBR-EDDL-HOME
route10 = Direction:West  Route:HOME-EDDG-EHAM-EBBR-EDDL-HOME
route11 =                 Route:HOME-EDLW-EDDW-EHAM-EDDL-HOME
route12 = Direction:West  Route:HOME-EDLW-EHAM-EDDW-EDDK-EDVK-HOME
route13 =                 Route:HOME-EDDH-EHAM-EDDG-HOME
route14 = Direction:North Route:HOME-EDDH-EDDB-HOME
route15 =                 Route:HOME-EDDT-EDDH-EDDW-EDDG-HOME
routezl = 15                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane5:            Beech King
enginetype  := 5            ; Engine-Type: Turboprop
emptyweight := 9090         ; in lbs (as in aircraft.cfg)
payloadG    := 120          ; Payload Baggage in kg
payloadS    := 249          ; Payload Cargo in kg
passenger   := 8            ; Passengers
bzb_range   := 1760         ; max range nm, lenght of stages will be calculated 
cruispd     := 280          ; Cruise Speed, kts 
stations     = 11           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 250          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDLW-HOME
route2 = Direction:West   Route:HOME-EDLW-EDDL-HOME
route3 = Direction:West   Route:HOME-EDDL-EDDW-HOME
route4 =                  Route:HOME-EDDB-EDDP-EDVK-HOME
route5 = Direction:South  Route:HOME-EDDK-EDDS-EDDP-EDDB-HOME
route6 = Direction:West   Route:HOME-EDDG-EDDK-EDDL-HOME
route7 = Direction:East   Route:HOME-EDDB-EDDH-EDDG-HOME
route8 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route9 =                  Route:HOME-EDDK-EBBR-EDDL-HOME
route10 = Direction:West  Route:HOME-EDDG-EHAM-EBBR-EDDL-HOME
route11 =                 Route:HOME-EDLW-EDDW-EHAM-EDDL-HOME
route12 = Direction:West  Route:HOME-EDLW-EHAM-EDDW-EDDK-EDVK-HOME
route13 =                 Route:HOME-EDDH-EHAM-EDDG-HOME
route14 = Direction:North Route:HOME-EDDH-EDDB-HOME
route15 = Direction:North Route:HOME-EDDH-EDDT-HOME
route16 =                 Route:HOME-EDDE-EDDS-EDDK-EDLV-HOME
route17 = Direction:West  Route:HOME-EDDL-EDDF-EBBR-EHAM-HOME
route18 = Direction:South Route:HOME-EDVK-EBBR-EDDF-HOME
route19 = Direction:West  Route:HOME-EHAM-EGLL-EHAM-HOME
route20 = Direction:South Route:HOME-EDDF-EBBR-LFPG-EDDK-HOME
route21 = Direction:South Route:HOME-EDDK-EBBR-LFPG-EGLL-EHAM-HOME
route22 = Direction:South Route:HOME-EDVK-EDDS-EDDF-EDVK-HOME
route23 = Direction:South Route:HOME-EDDF-EDDP-EDVK-HOME
route24 = Direction:West  Route:HOME-EDDF-EDDS-EDDK-HOME
route25 = Direction:South Route:HOME-EDDF-EDDM-LOWW-LHBP-EDDP-HOME ; !noch außer Betrieb
route26 = Direction:East  Route:HOME-EDDP-LHBP-EDDS-EDLW-HOME
routezl = 26                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane6:            DHC8 315Q
enginetype  := 5            ; Engine-Type: Turboprop
emptyweight := 25836        ; in lbs (as in aircraft.cfg)
payloadG    := 2200         ; Payload Baggage in kg
payloadS    := 3500         ; Payload Cargo in kg
passenger   := 50           ; Passengers
bzb_range   := 875          ; max range nm, lenght of stages will be calculated 
cruispd     := 285          ; Cruise Speed, kts 
stations     = 30           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 2            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 1            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 2            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 600          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-BxBZB      ; The name which ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route2 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route3 = Direction:South  Route:HOME-EDDK-EDDS-EDDP-EDDB-HOME
route4 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route5 =                  Route:HOME-EDDK-EBBR-EDDL-HOME
route6 = Direction:West   Route:HOME-EDDG-EHAM-EBBR-EDDL-HOME
route7 =                  Route:HOME-EDLW-EDDW-EHAM-EDDL-HOME
route8 = Direction:West   Route:HOME-EDLW-EHAM-EDDW-EDDK-EDDP-HOME
route9 =                  Route:HOME-EDDH-EHAM-EDDG-HOME
route10 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route11 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
route12 = Direction:West  Route:HOME-EDLP-EDLW-EDDG-EDLV-EDDW-HOME
route13 =                 Route:HOME-EDDF-LSZH-EDDR-EDDK-HOME
route14 =                 Route:HOME-EHBK-EDDS-LSZH-EDDE-HOME
routezl = 14                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane7:            Beech 1900C
enginetype  := 5            ; Engine-Type: Turboprop
emptyweight := 9750         ; in lbs (as in aircraft.cfg)
payloadG    := 190          ; Payload Baggage in kg
payloadS    := 600          ; Payload Cargo in kg
passenger   := 19           ; Passengers
bzb_range   := 630          ; no ":"!; max range nm, lenght of stages will be calculated 
cruispd     := 260          ; Cruise Speed, kts 
stations     = 22           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 590          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:home-EDDK-EBBR-EDDS-EDDM-EDDP-home
route2 =                  Route:home-EDDB-EDDP-EDDK-home
route3 = Direction:South  Route:home-EDDK-EDDS-EDDP-EDDB-home
route4 =                  Route:home-EDDG-EHAM-EDDL-home
route5 =                  Route:home-EDDK-EBBR-EDDL-home
route6 = Direction:West   Route:home-EDDG-EHAM-EBBR-EDDL-home
route7 =                  Route:home-EDLW-EDDW-EHAM-EDDL-home
route8 = Direction:West   Route:home-EDLW-EHAM-EDDW-EDDK-EDDP-home
route9 =                  Route:home-EDDH-EHAM-EDDG-home
route10 = Direction:East  Route:home-EDDB-EDDP-EDVK-home
route11 = Direction:South Route:home-EDVK-EDDP-EDDB-home
route12 = Direction:West  Route:home-EDLP-EDLW-EDDG-EDLV-EDDW-home
route13 =                 Route:home-EDDF-LSZH-EDDR-EDDK-home
route14 =                 Route:home-EHBK-EDDS-LSZH-EDDE-home
route15 =                 Route:Home-EDLP-EDLV-EDLN-EDLW-home
route16 =                 Route:home-EDHL-EKCH-EDDT-home
route17 =                 Route:home-EDDT-EDDH-EKCH-EDHL-home
route18 =                 Route:home-EDHL-EHAM-EDDW-EKCH-EDDT-home
route19 =                 Route:home-EDDE-LHBP-LOWW-EDDN-EDLN-home
routezl = 19            ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane8:            DHC Dash8-202
enginetype  := 5            ; Engine-Type: Turboprop
emptyweight := 23000        ; in lbs (as in aircraft.cfg)
payloadG    := 360          ; Payload Baggage, per passg 10 kg 
payloadS    := 450          ; Payload Cargo, =1000 lbs
passenger   := 36           ; Passengers
bzb_range   := 970          ; max range nm, lenght of stages will be calculated 
cruispd     := 275          ; Cruise Speed, kts 
stations     = 23           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 2003         ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 2            ; passengers per station
statperrow  := 4            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 454          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-BxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route2 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route3 = Direction:South  Route:HOME-EDDL-EDDS-EDDP-EDDB-HOME
route4 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route5 =                  Route:HOME-EDDF-EBBR-EDDL-HOME
route6 = Direction:West   Route:HOME-EDDG-EHRD-EBBR-EDDL-HOME
route7 =                  Route:HOME-EDLW-EDDW-EHAM-EDDF-HOME
route8 = Direction:West   Route:HOME-EHRD-EDDR-EDDS-EDDE-HOME
route9 =                  Route:HOME-EDLN-ELLX-LSGG-EDDM-EDFH-HOME
route10 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route11 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
route12 =                 Route:HOME-EDDT-EKCH-EDDH-HOME
route13 =                 Route:HOME-EDDF-EDDN-EDDE-EDDC-HOME
route14 =                 Route:HOME-EDLV-EHAM-EBBR-EDDK-EDDE-HOME
route15 = Direction:West  Route:HOME-EDLP-EDLW-EDDG-EDLV-EDDW-HOME
route16 =                 Route:HOME-EDDF-LSZH-EDDR-EDDK-HOME
route17 =                 Route:HOME-EDDN-LOWW-LIPZ-EDDM-EDDF-HOME
route18 =                 Route:HOME-EDDC-LHBP-LJLJ-LSZH-EDDK-HOME
route19 =                  Route:home-EDDF-EDDK-EBBR-ELLX-EDDL-home
route20 =                  Route:home-EHBK-EHRD-EGLL-LFPG-EDDK-home
routezl = 20                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane9:             ATR 72-500
enginetype  := 5            ; Engine-Type: Turboprop
emptyweight := 29762        ; in lbs (as in aircraft.cfg)  48502 max
payloadG    := 882          ; Payload Baggage in kg
payloadS    := 882          ; Payload Cargo in kg
passenger   := 68           ; Passengers
bzb_range   := 800          ; max range nm, lenght of stages will be calculated 
cruispd     := 285          ; Cruise Speed, kts 
stations     = 22           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 2            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 1019         ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 882          ; front baggage
pasperstat  := 4            ; passengers per station
statperrow  := 1            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 882          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-AxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:home-EDDK-EBBR-EDDS-EDDM-EDDP-home
route2 =                  Route:home-EDDB-EDDP-EDDK-home
route3 = Direction:South  Route:home-EDDL-EDDS-EDDP-EDDB-home
route4 =                  Route:home-EDLV-LFPG-EGJB-EHAM-EHRD-home
route5 =                  Route:home-EDDF-EDDK-EBBR-ELLX-EDDL-home
route6 = Direction:West   Route:home-EDDG-EHRD-EBBR-EDDL-home
route7 =                  Route:home-EDLW-EDLV-EHAM-EDDF-home
route8 = Direction:West   Route:home-EDLW-EHBK-EDDR-EDDS-EDDE-home
route9 =                  Route:home-EHBK-EHRD-EGLL-LFPG-EDDK-home
route10 = Direction:West  Route:home-EDLN-ELLX-LSGG-EDDM-EDFH-home
route11 = Direction:South Route:home-EDVK-EDFH-EBBR-EHRD-home
route12 =                 Route:home-EDDT-EKCH-EDDH-home
route13 =                 Route:home-EDDF-EDDN-EDDE-EDDC-home
route14 =                 Route:home-EDLV-EHAM-EBBR-EDDK-EDDE-home
route15 = Direction:West  Route:home-EDLP-EDLW-EDDG-EDLV-EDDW-home
route16 =                 Route:home-EDDF-LSZH-EDDR-EDDK-home
route17 = Direction:South Route:home-EDDF-EDDM-LOWW-LHBP-EDDP-home
route18 = Direction:East  Route:home-EDDP-LHBP-EDDS-EDLW-home
route19 =                 Route:home-EDDN-LOWW-LIPZ-EDDM-EDDF-home
route20 =                 Route:home-EDDT-EKCH-EDHL-EHAM-home
route21 =                 Route:home-EDHL-EHRD-EDDH-EKCH-EDDT-home
route22 = Direction:South Route:home-EDDF-EDDM-LOWW-LHBP-EDDP-home
route23 =                 Route:home-EDDC-LHBP-LJLJ-LSZH-EDDK-home
route24=                  Route:home-EHAM-EGLC-EGJJ-LFPG-EHBK-home
routezl = 24              ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane10:           DHC-5 Buffalo
enginetype  := 5            ; Engine-Type: Turboprop
emptyweight := 25836        ; in lbs (as in aircraft.cfg)
payloadG    := 1000         ; kg, Payload Baggage in kg
payloadS    := 2500         ; kg, Payload Cargo in kg
passenger   := 40           ; Passengers
bzb_range   := 935          ; max range nm, lenght of stages will be calculated 
cruispd     := 240          ; Cruise Speed, kts 
stations     = 27           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 2003         ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 1000         ; front baggage
pasperstat  := 2            ; passengers per station
statperrow  := 4            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 800          ; Rear Bags - max kg
aftcargo    := 1700         ; Rear Cargo, always the last
atcID        = D-IxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDDL-EDDG-HOME
route2 = Direction:West   Route:HOME-EDLW-EDDG-HOME
route3 =                  Route:HOME-EDDH-HOME
route4 =                  Route:HOME-EDLW-HOME
route5 = Direction:East   Route:HOME-EDDB-EDDP-EDVK-HOME
route6 = Direction:South  Route:HOME-EDVK-EDDP-EDDB-HOME
route7 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route8 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route9 = Direction:South  Route:HOME-EDDK-EDDS-EDDP-EDDB-HOME
route10 =                 Route:HOME-EDDG-EHAM-EDDL-HOME
route11 =                 Route:HOME-EDDK-EBBR-EDDL-HOME
route12 = Direction:West  Route:HOME-EDDG-EHAM-EBBR-EDDL-HOME
route13 =                 Route:HOME-EDLW-EDDW-EHAM-EDDL-HOME
route14 = Direction:West  Route:HOME-EDLW-EHAM-EDDW-EDDK-EDDP-HOME
route15 =                 Route:HOME-EDDH-EHAM-EDDG-HOME
route16 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route17 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
route18 =                 Route:HOME-EDDF-LSZH-EDDR-EDDK-HOME
route19 = Direction:West  Route:HOME-EHAM-EBBR-EDDS-EDVK-HOME
route20 = Direction:East  Route:HOME-EDDP-EDVK-EDDS-EBBR-EDDK-HOME
routezl = 20                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane11:         TransAll C-160
enginetype  := 5           ; Engine-Type: Turboprop
emptyweight := 61730       ; in lbs (as in aircraft.cfg)
payloadG    := 500         ; Payload Baggage in kg
payloadS    := 14000       ; Payload Cargo in kg
passenger   := 24          ; Passengers
bzb_range   := 650         ; max range nm, lenght of stages will be calculated 
cruispd     := 260         ; Cruise Speed, kts
stations     = 20           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 2003         ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 500          ; front baggage
pasperstat  := 2            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 500          ; Rear Bags - max kg
aftcargo    := 1000         ; Rear Cargo, always the last
atcID        = D-AxBZB     ; The name ATC uses to call your airplane
HOME         = EDDV        ; your home airport, all routes start and end here

route1 = Direction:East   Route:HOME-EDDB-EDDP-EDVK-HOME
route2 = Direction:South  Route:HOME-EDVK-EDDP-EDDB-HOME
route3 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route4 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route5 = Direction:South  Route:HOME-EDDK-EDDS-EDDP-EDDB-HOME
route6 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route7 =                  Route:HOME-EDDK-EBBR-EDDL-HOME
route8 =  Direction:West  Route:HOME-EDDG-EHAM-EBBR-EDDL-HOME
route9 =                  Route:HOME-EDLW-EDDW-EHAM-EDDL-HOME
route10 = Direction:West  Route:HOME-EDLW-EHAM-EDDW-EDDK-EDDP-HOME
route11 =                 Route:HOME-EDDH-EHAM-EDDG-HOME
route12 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route13 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
route14 =                 Route:HOME-EDDF-LSZH-EDDR-EDDK-HOME
route15 = Direction:West  Route:HOME-EHAM-EBBR-EDDS-EDVK-HOME
route16 = Direction:East  Route:HOME-EDDP-EDVK-EDDS-EBBR-EDDK-HOME
route17 =                 Route:HOME-EDDN-LOWW-LIPZ-EDDM-EDDF-HOME
route18 =                 Route:HOME-EDDC-LHBP-LJLJ-LSZH-EDDK-HOME
route19 =                  Route:home-EDDF-EDDK-EBBR-ELLX-EDDL-home
route20 =                  Route:home-EHBK-EHRD-EGLL-LFPG-EDDK-home
routezl = 20                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane12:         DeHavilland Beaver
enginetype  := 0           ; Engine-Type: Piston
emptyweight := 3410        ; in lbs (as in aircraft.cfg)
payloadG    := 100         ; Payload Baggage in kg
payloadS    := 190         ; Payload Cargo in kg
passenger   := 5           ; Passengers
bzb_range   := 395         ; max range nm, lenght of stages will be calculated 
cruispd     := 124         ; Cruise Speed, kts 
stations     = -7           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 1            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 6            ; Rear Bags - stat number
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-ExBZB     ; The name ATC uses to call your airplane
HOME         = EDDV        ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDVW-EDVS-HOME
route3  = Route:HOME-EDDW-EDXI-HOME
route4  = Route:HOME-EDVS-EDVW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDXI-EDDW-EDVH-HOME
route9  = Route:HOME-EDVW-EDVY-HOME
route10 = Route:HOME-EDVR-EDLP-EDVW-HOME
route11 = Route:HOME-EDVW-EDLP-EDVY-HOME
routezl = 11                  ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane13:         Grand Caravan
enginetype  := 0            ; Engine-Type: Piston
emptyweight := 4575         ; in lbs (as in aircraft.cfg)
payloadG    := 180          ; Payload Baggage in kg
payloadS    := 650          ; Payload Cargo in kg
passenger   := 9            ; Passengers
bzb_range   := 630          ; max range nm, lenght of stages will be calculated 
cruispd     := 195          ; Cruise Speed, kts 
stations     = -10          ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 1            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 10011        ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 200          ; Rear Bags - max kg
aftcargo    := 200          ; Rear Cargo, always the last
atcID        = D-FxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDLP-EDLW-EDDG-HOME
route3  = Route:HOME-EDDW-EDVY-HOME
route4  = Route:HOME-EDDG-EDDW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDDG-HOME
route9  = Direction:West Route:HOME-EDDG-HOME
route10 = Route:HOME-EDLW-HOME
route11 = Route:HOME-EDLW-EDDG-HOME
route12 = Route:HOME-EDVR-EDLP-EDVW-HOME
route13 = Route:HOME-EDDW-EDDG-EDLP-HOME
route14 = Route:HOME-EDDW-EDDG-EDLP-HOME
routezl = 14                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane14:         Douglas DC-3
enginetype  := 0            ; Engine-Type: Piston
emptyweight := 16145        ; in lbs (as in aircraft.cfg)
payloadG    := 640          ; Payload Baggage in kg
payloadS    := 920          ; Payload Cargo in kg
passenger   := 32           ; Passengers
bzb_range   := 1800         ; max range nm, lenght of stages will be calculated 
cruispd     := 161          ; Cruise Speed, kts 
stations     = -12          ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 200          ; front baggage
pasperstat  := 4            ; passengers per station
statperrow  := 1            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 0            ; Rear Bags - max kg
aftcargo    := 200          ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDLP-EDLW-EDDG-HOME
route3  = Route:HOME-EDDW-EDVY-HOME
route4  = Route:HOME-EDDG-EDDW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDDG-HOME
route9  = Direction:West Route:HOME-EDDG-HOME
route10 = Route:HOME-EDLW-HOME
route11 = Route:HOME-EDLW-EDDG-HOME
route12 = Route:HOME-EDVR-EDLP-EDVW-HOME
route13 = Route:HOME-EDDW-EDDG-EDLP-HOME
route14 = Route:HOME-EDDW-EDDG-EDLP-HOME
routezl = 14                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane15:         Hawker Siddeley
enginetype  := 5            ; Engine-Type: 5 = Turboprop
emptyweight := 27709        ; in lbs (as in aircraft.cfg)
payloadG    := 800          ; Payload Baggage in kg
payloadS    := 1260         ; Payload Cargo in kg
passenger   := 40           ; Passengers
bzb_range   := 2600         ; max range nm, lenght of stages will be calculated 
cruispd     := 220          ; Cruise Speed, kts 
stations     = 15           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 2            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 1            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 400          ; front baggage
pasperstat  := 4            ; passengers per station
statperrow  := 1            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 400          ; Rear Bags - max kg
aftcargo    := 1360         ; Rear Cargo, always the last
atcID        = D-BxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route2 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route3 = Direction:South  Route:HOME-EDDL-EDDS-EDDP-EDDB-HOME
route4 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route5 =                  Route:HOME-EDDF-EBBR-EDDL-HOME
route6 = Direction:West   Route:HOME-EDDG-EHRD-EBBR-EDDL-HOME
route7 =                  Route:HOME-EDLW-EDDW-EHAM-EDDF-HOME
route8 = Direction:West   Route:HOME-EDLW-EHRD-EDDR-EDDS-EDDE-HOME
route9 =                  Route:HOME-EDDH-EHAM-EDDG-HOME
route10 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route11 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
route12 =                 Route:HOME-EDDT-EKCH-EDDH-HOME
route13 =                 Route:HOME-EDDF-EDDN-EDDE-EDDC-HOME
route14 =                 Route:HOME-EDLV-EHAM-EBBR-EDDK-EDDE-HOME
route15 = Direction:West  Route:HOME-EDLP-EDLW-EDDG-EDLV-EDDW-HOME
route16 =                 Route:HOME-EDDF-LSZH-EDDR-EDDK-HOME
route17 =                 Route:HOME-EDDN-LOWW-LIPZ-EDDM-EDDF-HOME
route18 =                 Route:HOME-EDDC-LHBP-LJLJ-LSZH-EDDK-HOME
routezl = 18                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane16:         Piaggio P-180
enginetype  := 5            ; Engine-Type: 0 = Piston
emptyweight := 7402         ; in lbs (as in aircraft.cfg)
payloadG    := 120          ; Payload Baggage in kg
payloadS    := 790          ; Payload Cargo in kg
passenger   := 6            ; Passengers
bzb_range   := 1500         ; max range nm, lenght of stages will be calculated 
cruispd     := 318          ; Cruise Speed, kts 
stations     = -9           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 357          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-IxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDLW-HOME
route2 = Direction:West   Route:HOME-EDLW-EDDL-HOME
route3 = Direction:West   Route:HOME-EDDL-EDDW-HOME
route4 =                  Route:HOME-EDDB-EDDP-EDVK-HOME
route5 = Direction:South  Route:HOME-EDDK-EDDS-EDDP-EDDB-HOME
route6 = Direction:West   Route:HOME-EDDG-EDDK-EDDL-HOME
route7 = Direction:East   Route:HOME-EDDB-EDDH-EDDG-HOME
route8 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route9 =                  Route:HOME-EDDK-EBBR-EDDL-HOME
route10 = Direction:West  Route:HOME-EDDG-EHAM-EBBR-EDDL-HOME
routezl = 10                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane17:          Beech D18S
enginetype  := 0            ; Engine-Type: 0 = Piston
emptyweight := 5527         ; 8750 MaxTOWeight in lbs (as in aircraft.cfg)
payloadG    := 160          ; Payload Baggage in kg
payloadS    := 240          ; Payload Cargo in kg
passenger   := 8            ; Passengers 2 Piloten
bzb_range   := 900          ; max range nm, lenght of stages will be calculated 
cruispd     := 183          ; Cruise Speed, kts 
stations     = 12           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 114          ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 122          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-IxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDLP-EDLW-EDDG-HOME
route3  = Route:HOME-EDVY-HOME
route4  = Route:HOME-EDDG-HOME
route5  = Direction:West Route:HOME-EDDG-HOME
route6  = Route:HOME-EDLW-HOME
route7  = Route:HOME-EDLW-EDDG-HOME
route8  = Route:HOME-EDVR-EDLP-EDVW-HOME
route9  = Route:HOME-EDDW-EDDG-EDLP-HOME
route10 = Route:HOME-EDDW-EDDG-EDLP-HOME
routezl = 10                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane18:          Bombardier DH8-400
enginetype  := 5            ; Engine-Type: 0 = Piston
emptyweight := 37836        ; in lbs (as in aircraft.cfg)
payloadG    := 1400         ; Payload Baggage in kg
payloadS    := 4100         ; Payload Cargo in kg
passenger   := 74           ; Passengers
bzb_range   := 1500         ; max range nm, lenght of stages will be calculated 
cruispd     := 340          ; Cruise Speed, kts 
stations     = 23           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 2            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 1            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 700          ; front baggage
pasperstat  := 4            ; passengers per station
statperrow  := 1            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 1400         ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-AxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:home-EDDK-EBBR-EDDS-EDDM-EDDP-home
route2 =                  Route:home-EDDB-EDDP-EDDK-home
route3 = Direction:South  Route:home-EDDL-EDDS-EDDP-EDDB-home
route4 =                  Route:home-EHAM-EDDL-home
route5 =                  Route:home-EDDF-EDDR-EBBR-ELLX-EDDL-home
route6 = Direction:West   Route:home-EHRD-EBBR-EDDL-home
route7 =                  Route:home-EDLV-EHAM-EDDF-home
route8 = Direction:West   Route:home-EDLW-EHBK-EDDR-EDDS-EDDE-home
route9 = Direction:West   Route:home-EDLN-ELLX-LSGG-EDDM-EDFH-home
route10 =                 Route:home-EDDT-EKCH-EDDH-home
route11 =                 Route:home-EDDF-EDDM-EDDE-EDDB-home
route12 =                 Route:home-EDLV-EHAM-EBBR-EDDK-EDDE-home
route13 =                 Route:home-EDDF-LSZH-EDDR-EDDK-home
route14 = Direction:South Route:home-EDDF-EDDM-LOWW-LHBP-EDDP-home
route15 = Direction:East  Route:home-EDDP-LHBP-EDDS-ELLX-EDDL-home
route16 =                 Route:home-EDDN-LOWW-LIPZ-EDDM-EDDF-home
route17 =                 Route:home-EDDT-EKCH-EDHL-EHAM-home
route18 =                 Route:home-EDHL-EHRD-EDDH-EKCH-EDDT-home
route19 = Direction:South Route:home-EDFH-EDDM-LOWW-LHBP-EDDC-home
route20 =                 Route:home-EDDC-LHBP-LJLJ-LSZH-EDFH-home
routezl = 20                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane19:          Cessna 310Q
enginetype  := 0            ; Engine-Type: 0 = Piston
emptyweight := 3600         ; in lbs (as in aircraft.cfg)
payloadG    := 80           ; Payload Baggage in kg
payloadS    := 360          ; Payload Cargo in kg
passenger   := 4            ; Passengers
bzb_range   := 630          ; max range nm, lenght of stages will be calculated 
cruispd     := 195          ; Cruise Speed, kts 
stations     = -10          ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 50           ; Rear Bags - max kg
aftcargo    := 50           ; Rear Cargo, always the last
atcID        = D-IxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDLP-EDLW-EDDG-HOME
route3  = Route:HOME-EDDW-EDVY-HOME
route4  = Route:HOME-EDDG-EDDW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDDG-HOME
route9  = Direction:West Route:HOME-EDDG-HOME
route10 = Route:HOME-EDLW-HOME
routezl = 10                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane20:          Dornier D28A
enginetype  := 0            ; Engine-Type: 0 = Piston
emptyweight := 3806         ; in lbs (as in aircraft.cfg)
payloadG    := 100          ; Payload Baggage in kg
payloadS    := 450          ; Payload Cargo in kg
passenger   := 5            ; Passengers
bzb_range   := 500          ; max range nm, lenght of stages will be calculated 
cruispd     := 130          ; Cruise Speed, kts 
stations     = 7            ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 1            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 50           ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-IxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDLP-EDLW-EDDG-HOME
route3  = Route:HOME-EDDW-EDVY-HOME
route4  = Route:HOME-EDDG-EDDW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDDG-HOME
route9  = Direction:West Route:HOME-EDDG-HOME
route10 = Route:HOME-EDLW-HOME
routezl = 10                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane21:          Lockheed 18-C-60
enginetype  := 0            ; Engine-Type: 0 = Piston
emptyweight := 12216        ; in lbs (as in aircraft.cfg)
payloadG    := 280          ; Payload Baggage in kg
payloadS    := 730          ; Payload Cargo in kg
passenger   := 14           ; Passengers
bzb_range   := 1400         ; max range nm, lenght of stages will be calculated 
cruispd     := 174          ; Cruise Speed, kts 
stations     = 18           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 100          ; Rear Bags - max kg
aftcargo    := 50           ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDLP-EDLW-EDDG-HOME
route3  = Route:HOME-EDDW-EDVY-HOME
route4  = Route:HOME-EDDG-EDDW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDDG-HOME
route9  = Direction:West Route:HOME-EDDG-HOME
route10 = Route:HOME-EDLW-HOME
routezl = 10                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane22:          CASA C-212-200
enginetype  := 5            ; Engine-Type: 0 = Piston
emptyweight := 8818         ; in lbs (as in aircraft.cfg)
payloadG    := 320          ; Payload Baggage in kg
payloadS    := 200          ; Payload Cargo in kg
passenger   := 16           ; Passengers
bzb_range   := 770          ; max range nm, lenght of stages will be calculated 
cruispd     := 210          ; Cruise Speed, kts 
stations     = 19           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 3            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 130          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDLP-EDLW-EDDG-HOME
route3  = Route:HOME-EDDW-EDVY-HOME
route4  = Route:HOME-EDDG-EDDW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDDG-HOME
route9  = Direction:West Route:HOME-EDDG-HOME
route10 = Route:HOME-EDLW-HOME
routezl = 10                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane23:          Embraer EMB120ER
enginetype  := 5            ; Engine-Type: 0 = Piston
emptyweight := 10700        ; in lbs (as in aircraft.cfg)
payloadG    := 600          ; Payload Baggage in kg
payloadS    := 3160         ; Payload Cargo in kg
passenger   := 30           ; Passengers
bzb_range   := 850          ; max range nm, lenght of stages will be calculated 
cruispd     := 260          ; Cruise Speed, kts 
stations     = 32           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 2            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 3            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 500          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route2 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route3 = Direction:South  Route:HOME-EDDL-EDDS-EDDP-EDDB-HOME
route4 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route5 =                  Route:HOME-EDDF-EBBR-EDDL-HOME
route6 = Direction:West   Route:HOME-EDDG-EHRD-EBBR-EDDL-HOME
route7 =                  Route:HOME-EDLW-EDDW-EHAM-EDDF-HOME
route8 = Direction:West   Route:HOME-EDLW-EHRD-EDDR-EDDS-EDDE-HOME
route9 =                  Route:HOME-EDDH-EHAM-EDDG-HOME
route10 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
routezl = 10                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane24:          Saab 340B
enginetype  := 5            ; Engine-Type: 0 = Piston
emptyweight := 17945         ; in lbs (as in aircraft.cfg)
payloadG    := 660          ; Payload Baggage in kg
payloadS    := 1138         ; Payload Cargo in kg
passenger   := 33           ; Passengers
bzb_range   := 930          ; max range nm, lenght of stages will be calculated 
cruispd     := 265          ; Cruise Speed, kts 
stations     = 26           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 2            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 3            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 600          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route2 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route3 = Direction:South  Route:HOME-EDDL-EDDS-EDDP-EDDB-HOME
route4 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route5 =                  Route:HOME-EDDF-EBBR-EDDL-HOME
route6 = Direction:West   Route:HOME-EDDG-EHRD-EBBR-EDDL-HOME
route7 =                  Route:HOME-EDLW-EDDW-EHAM-EDDF-HOME
route8 = Direction:West   Route:HOME-EDLW-EHRD-EDDR-EDDS-EDDE-HOME
route9 =                  Route:HOME-EDDH-EHAM-EDDG-HOME
route10 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route11 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
routezl = 11                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane25:          Howard 500
enginetype  := 0            ; Engine-Type: 0 = Piston
emptyweight := 24000        ; in lbs (as in aircraft.cfg)
payloadG    := 240          ; Payload Baggage in kg
payloadS    := 1600         ; Payload Cargo in kg
passenger   := 12           ; Passengers
bzb_range   := 2231         ; max range nm, lenght of stages will be calculated 
cruispd     := 306          ; Cruise Speed, kts 
stations     = 11           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 200          ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 200          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-BxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route2 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route3 = Direction:South  Route:HOME-EDDL-EDDS-EDDP-EDDB-HOME
route4 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route5 =                  Route:HOME-EDDF-EBBR-EDDL-HOME
route6 = Direction:West   Route:HOME-EDDG-EHRD-EBBR-EDDL-HOME
route7 =                  Route:HOME-EDLW-EDDW-EHAM-EDDF-HOME
route8 = Direction:West   Route:HOME-EDLW-EHRD-EDDR-EDDS-EDDE-HOME
route9 =                  Route:HOME-EDDH-EHAM-EDDG-HOME
route10 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route11 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
route12 =                 Route:HOME-EDDT-EKCH-EDDH-HOME
routezl = 12                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane26:          Grumman Goose
enginetype  := 0            ; Engine-Type: 0 = Piston
emptyweight := 6923         ; in lbs (as in aircraft.cfg)
payloadG    := 120          ; Payload Baggage in kg
payloadS    := 0            ; Payload Cargo in kg
passenger   := 8            ; Passengers
bzb_range   := 556          ; max range nm, lenght of stages will be calculated 
cruispd     := 165          ; Cruise Speed, kts 
stations     = -12          ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 100          ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 3            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 100          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-IxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1  = Route:HOME-EDVE-EDBM-EDVC-HOME
route2  = Route:HOME-EDVY-EDLP-EDLW-EDDG-HOME
route3  = Route:HOME-EDDW-EDVY-HOME
route4  = Route:HOME-EDDG-EDDW-HOME
route5  = Route:HOME-EDDH-EDDW-HOME
route6  = Route:HOME-EDVE-HOME
route7  = Route:HOME-EDVY-HOME
route8  = Route:HOME-EDDG-HOME
route9  = Direction:West Route:HOME-EDDG-HOME
routezl = 9                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane27:          Beech B1900D
enginetype  := 5            ; Engine-Type: 0 = Piston
emptyweight := 10593        ; in lbs (as in aircraft.cfg)
payloadG    := 380          ; Payload Baggage in kg
payloadS    := 1560         ; Payload Cargo in kg
passenger   := 19           ; Passengers
bzb_range   := 630          ; max range nm, lenght of stages will be calculated 
cruispd     := 280          ; Cruise Speed, kts 
stations     = 22           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 590          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route2 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route3 = Direction:South  Route:HOME-EDDK-EDDS-EDDP-EDDB-HOME
route4 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route5 =                  Route:HOME-EDDK-EBBR-EDDL-HOME
route6 = Direction:West   Route:HOME-EDDG-EHAM-EBBR-EDDL-HOME
route7 =                  Route:HOME-EDLW-EDDW-EHAM-EDDL-HOME
route8 = Direction:West   Route:HOME-EDLW-EHAM-EDDW-EDDK-EDDP-HOME
route9 =                  Route:HOME-EDDH-EHAM-EDDG-HOME
route10 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route11 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
route12 = Direction:West  Route:HOME-EDLP-EDLW-EDDG-EDLV-EDDW-HOME
route13 =                 Route:HOME-EDDF-LSZH-EDDR-EDDK-HOME
route14 =                 Route:HOME-EHBK-EDDS-LSZH-EDDE-HOME
routezl = 14                 ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane28:          Casa C-295M
enginetype  := 5            ; Engine-Type: 0 = Piston
emptyweight := 30700        ; in lbs (as in aircraft.cfg)
payloadG    := 400          ; Payload Baggage in kg
payloadS    := 5204         ; Payload Cargo in kg
passenger   := 20           ; Passengers
bzb_range   := 600          ; max range nm, lenght of stages will be calculated 
cruispd     := 260          ; Cruise Speed, kts 
stations     = 23           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 2            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 1            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 200          ; Rear Bags - max kg
aftcargo    := 3800         ; Rear Cargo, always the last
atcID        = D-AxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 = Direction:East   Route:HOME-EDDB-EDDP-EDVK-HOME
route2 = Direction:South  Route:HOME-EDVK-EDDP-EDDB-HOME
route3 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route4 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route5 = Direction:South  Route:HOME-EDDK-EDDS-EDDP-EDDB-HOME
route6 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route7 =                  Route:HOME-EDDK-EBBR-EDDL-HOME
route8 =  Direction:West  Route:HOME-EDDG-EHAM-EBBR-EDDL-HOME
route9 =                  Route:HOME-EDLW-EDDW-EHAM-EDDL-HOME
route10 = Direction:West  Route:HOME-EDLW-EHAM-EDDW-EDDK-EDDP-HOME
route11 =                 Route:HOME-EDDH-EHAM-EDDG-HOME
route12 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route13 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
route14 =                 Route:HOME-EDDF-LSZH-EDDR-EDDK-HOME
route15 = Direction:West  Route:HOME-EHAM-EBBR-EDDS-EDVK-HOME
route16 = Direction:East  Route:HOME-EDDP-EDVK-EDDS-EBBR-EDDK-HOME
route17 =                 Route:HOME-EDDN-LOWW-LIPZ-EDDM-EDDF-HOME
route18 =                 Route:HOME-EDDC-LHBP-LJLJ-LSZH-EDDK-HOME
routezl = 18                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane29:          DHC Dash8-102
enginetype  := 5            ; Engine-Type: 0 = Piston
emptyweight := 22100        ; in lbs (as in aircraft.cfg)
payloadG    := 720          ; Payload Baggage in kg
payloadS    := 1350         ; Payload Cargo in kg
passenger   := 36           ; Passengers
bzb_range   := 500          ; max range nm, lenght of stages will be calculated 
cruispd     := 265          ; Cruise Speed, kts 
stations     = 23           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 2003         ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 2            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 454          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-BxBZB      ; The name ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route2 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route3 = Direction:South  Route:HOME-EDDL-EDDS-EDDP-EDDB-HOME
route4 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route5 =                  Route:HOME-EDDF-EBBR-EDDL-HOME
route6 = Direction:West   Route:HOME-EDDG-EHRD-EBBR-EDDL-HOME
route7 =                  Route:HOME-EDLW-EDDW-EHAM-EDDF-HOME
route8 = Direction:West   Route:HOME-EDLW-EHRD-EDDR-EDDS-EDDE-HOME
route9 =                  Route:HOME-EDDH-EHAM-EDDG-HOME
route10 =                 Route:HOME-EDDN-LOWW-LIPZ-EDDM-EDDF-HOME
route11 =                 Route:HOME-EDDC-LHBP-LJLJ-LSZH-EDDK-HOME
routezl = 11                   ; Number of Routes in this block / Anzahl benutzter Routen
Return


;=Airplane30:          Learjet 45
enginetype  := 1            ; Engine-Type: 0 = Piston
emptyweight := 11700        ; in lbs (as in aircraft.cfg)
payloadG    := 100          ; Payload Baggage in kg
payloadS    := 50           ; Payload Cargo in kg
passenger   := 8            ; Passengers
bzb_range   := 800          ; max range nm, lenght of stages will be calculated 
cruispd     := 464          ; Cruise Speed, kts 
stations     = -12          ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 1 or 2 = 4 Passg; bigger airplanes not supported
aftbags     := 100          ; Rear Bags - max kg
aftcargo    := 50           ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name that ATC uses to call your airplane
HOME         = EDDV         ; your home airport, all routes start and end here

route1 =                  Route:home-EDDK-EBBR-EDDS-EDDM-EDDP-home
route2 =                  Route:home-EDDB-EDDP-EDDK-home
route3 = Direction:South  Route:home-EDDL-EDDS-EDDP-EDDB-home
route4 =                  Route:home-EHAM-EDDL-home
route5 =                  Route:home-EDDF-EDDR-EBBR-ELLX-EDDL-home
route6 = Direction:West   Route:home-EHRD-EBBR-EDDL-home
route7 =                  Route:home-EDLV-EHAM-EDDF-home
route8 = Direction:West   Route:home-EDLW-EHBK-EDDR-EDDS-EDDE-home
route9 = Direction:West   Route:home-EDLN-ELLX-LSGG-EDDM-EDFH-home
route10 =                 Route:home-EDDT-EKCH-EDDH-home
route11 =                 Route:home-EDDF-EDDM-EDDE-EDDB-home
route12 =                 Route:home-EDLV-EHAM-EBBR-EDDK-EDDE-home
route13 =                 Route:home-EDDF-LSZH-EDDR-EDDK-home
route14 = Direction:South Route:home-EDDF-EDDM-LOWW-LHBP-EDDP-home
route15 = Direction:East  Route:home-EDDP-LHBP-EDDS-ELLX-EDDL-home
route16 =                 Route:home-EDDN-LOWW-LIPZ-EDDM-EDDF-home
route17 =                 Route:home-EDDT-EKCH-EDHL-EHAM-home
route18 =                 Route:home-EDHL-EHRD-EDDH-EKCH-EDDT-home
route19 = Direction:South Route:home-EDFH-EDDM-LOWW-LHBP-EDDC-home
route20 =                 Route:home-EDDC-LHBP-LJLJ-LSZH-EDFH-home
routezl = 20                   ; Number of Routes in this block / Anzahl benutzter Routen
Return

;=Airplane31:          ATR 72-600
enginetype  := 5
emptyweight := 28550        ; in lbs (as in aircraft.cfg)  48502 max
payloadG    := 882          ; Payload Baggage in kg
payloadS    := 882          ; Payload Cargo in kg
passenger   := 64           ; Passengers
bzb_range   := 800          ; max range nm, lenght of stages will be calculated 
cruispd     := 285          ; Cruise Speed, kts 
stations     = -74	
pilots      := ?            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 0            ; passengers per station
statperrow  := 0            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 0            ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-ABZBx
HOME         = EDDV

route1 =                  Route:home-EDDK-EBBR-EDDS-EDDM-EDDP-home
route2 =                  Route:home-EDDB-EDDP-EDDK-home
route3 = Direction:South  Route:home-EDDL-EDDS-EDDP-EDDB-home
route4 =                  Route:home-EDLV-LFPG-EGJB-EHAM-EHRD-home
route5 =                  Route:home-EDDF-EDDK-EBBR-ELLX-EDDL-home
route6 = Direction:West   Route:home-EDDG-EHRD-EBBR-EDDL-home
route7 =                  Route:home-EDLW-EDLV-EHAM-EDDF-home
route8 = Direction:West   Route:home-EDLW-EHBK-EDDR-EDDS-EDDE-home
route9 =                  Route:home-EHBK-EHRD-EGLL-LFPG-EDDK-home
route10 = Direction:West  Route:home-EDLN-ELLX-LSGG-EDDM-EDFH-home
route11 = Direction:South Route:home-EDVK-EDFH-EBBR-EHRD-home
route12 =                 Route:home-EDDT-EKCH-EDDH-home
route13 =                 Route:home-EDDF-EDDN-EDDE-EDDC-home
route14 =                 Route:home-EDLV-EHAM-EBBR-EDDK-EDDE-home
route15 = Direction:West  Route:home-EDLP-EDLW-EDDG-EDLV-EDDW-home
route16 =                 Route:home-EDDF-LSZH-EDDR-EDDK-home
route17 = Direction:South Route:home-EDDF-EDDM-LOWW-LHBP-EDDP-home
route18 = Direction:East  Route:home-EDDP-LHBP-EDDS-EDLW-home
route19 =                 Route:home-EDDN-LOWW-LIPZ-EDDM-EDDF-home
route20 =                 Route:home-EDDT-EKCH-EDHL-EHAM-home
route21 =                 Route:home-EDHL-EHRD-EDDH-EKCH-EDDT-home
route22 = Direction:South Route:home-EDDF-EDDM-LOWW-LHBP-EDDP-home
route23 =                 Route:home-EDDC-LHBP-LJLJ-LSZH-EDDK-home
route24=                  Route:home-EHAM-EGLC-EGJJ-LFPG-EHBK-home
routezl = 24              ; Number of Routes in this block / Anzahl benutzter Routen
Return

;=Airplane32:         TransAll C-160F
enginetype  := 5           ; Engine-Type: Turboprop
emptyweight := 61730       ; in lbs (as in aircraft.cfg)
payloadG    := 500         ; Payload Baggage in kg
payloadS    := 14000       ; Payload Cargo in kg
passenger   := 24          ; Passengers
bzb_range   := 650         ; max range nm, lenght of stages will be calculated 
cruispd     := 260         ; Cruise Speed, kts
stations     = -24         ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 2003         ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 500          ; front baggage
pasperstat  := 2            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 500          ; Rear Bags - max kg
aftcargo    := 1000         ; Rear Cargo, always the last
atcID        = D-AxBZB     ; The name ATC uses to call your airplane
HOME         = EDDV        ; your home airport, all routes start and end here

route1 = Direction:East   Route:HOME-EDDB-EDDP-EDVK-HOME
route2 = Direction:South  Route:HOME-EDVK-EDDP-EDDB-HOME
route3 =                  Route:HOME-EDDK-EBBR-EDDS-EDDM-EDDP-HOME
route4 =                  Route:HOME-EDDB-EDDP-EDDK-HOME
route5 = Direction:South  Route:HOME-EDDK-EDDS-EDDP-EDDB-HOME
route6 =                  Route:HOME-EDDG-EHAM-EDDL-HOME
route7 =                  Route:HOME-EDDK-EBBR-EDDL-HOME
route8 =  Direction:West  Route:HOME-EDDG-EHAM-EBBR-EDDL-HOME
route9 =                  Route:HOME-EDLW-EDDW-EHAM-EDDL-HOME
route10 = Direction:West  Route:HOME-EDLW-EHAM-EDDW-EDDK-EDDP-HOME
route11 =                 Route:HOME-EDDH-EHAM-EDDG-HOME
route12 = Direction:East  Route:HOME-EDDB-EDDP-EDVK-HOME
route13 = Direction:South Route:HOME-EDVK-EDDP-EDDB-HOME
route14 =                 Route:HOME-EDDF-LSZH-EDDR-EDDK-HOME
route15 = Direction:West  Route:HOME-EHAM-EBBR-EDDS-EDVK-HOME
route16 = Direction:East  Route:HOME-EDDP-EDVK-EDDS-EBBR-EDDK-HOME
route17 =                 Route:HOME-EDDN-LOWW-LIPZ-EDDM-EDDF-HOME
route18 =                 Route:HOME-EDDC-LHBP-LJLJ-LSZH-EDDK-HOME
route19 =                  Route:home-EDDF-EDDK-EBBR-ELLX-EDDL-home
route20 =                  Route:home-EHBK-EHRD-EGLL-LFPG-EDDK-home
routezl = 20                   ; Number of Routes in this block / Anzahl benutzter Routen
Return

;=Airplane33:          LM C-130J
enginetype  := 5
emptyweight := 75600
payloadG    := 750
payloadS    := 0
passenger   := 50
bzb_range   := 1000
cruispd     := 250
stations     = -6
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 2003         ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 0            ; passengers per station
statperrow  := 50           ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 1000         ; Rear Bags - max kg
aftcargo    := 17000        ; Rear Cargo, always the last
atcID        = D-A2BZB
HOME         = EDDV

route1  = Route:HOME-EDLN-EDDE-EDFH-EDVM-EDLV-HOME
route2  = Route:HOME-EDDE-EDDT-EDXI-EDDE-HOME
route3  = Route:HOME-EDLW-EDDE-HOME
route4  = Route:HOME-EDDG-HOME
route5  = Route:HOME-EDLN-EDXI-EDLW-EDBM-EDDC-HOME
route6  = Route:HOME-EDLN-EHAM-HOME
route7  = Route:HOME-EHBK-EDVK-EDBM-EDDK-EDFE-HOME
route8  = Route:HOME-EDLW-EDFE-EDLN-HOME
route9  = Route:HOME-EDDK-EHRD-EDDK-EHAM-HOME
route10  = Route:HOME-EDDN-LOWS-LOWK--HOME
routezl = 10
Return


;=Airplane34:          ATR 72-210
enginetype  := 5
emptyweight := 27337.000
payloadG    := 990
payloadS    := 0
passenger   := 66
bzb_range   := 800
cruispd     := 280
stations     = -1	
pilots      := 2            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 0            ; passengers per station
statperrow  := 0            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 0            ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        =D-A4BZB
HOME         = EDDM

route1  = Route:HOME-LSZH-LOWI-HOME
route2  = Route:HOME-EDDR-EDLN-EDDN-HOME
route3  = Route:HOME-EDDP-EDFH-HOME
route4  = Route:HOME-ELLX-HOME
route5  = Route:HOME-LIML-HOME
route6  = Route:HOME-EDBM-EDVK-HOME
route7  = Route:HOME-EDDS-LOWS-HOME
route8  = Route:HOME-LSZB-LFLY-LSZH-HOME
route9  = Route:HOME-EDFH-LSGG-LIMJ-LFML-LSZB-HOME
route10  = Route:HOME-LOWK-LIML-LIPZ-HOME
routezl = 10
Return


;=Airplane35:          L-410 UVP-E
enginetype  := 5
emptyweight := 8818
payloadG    := 285
payloadS    := 200
passenger   := 19
bzb_range   := 300
cruispd     := 180
stations     = -19
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 3            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 200          ; Rear Bags - max kg
aftcargo    := 200          ; Rear Cargo, always the last
atcID        =D-CBZB2
HOME         = EDDV

route1  = Route:HOME-EDLV-ETNW-EDLN-EDVM-HOME
route2  = Route:HOME-EDLV-ELLX-EDDS-EDDF-HOME
route3  = Route:HOME-EDDK-EDLP-ELLX-EDDK-HOME
route4  = Route:HOME-EDDG-EDDE-EDVY-EDDP-HOME
route5  = Route:HOME-EDDL-EBBR-EHRD-EDLV-EDVH-HOME
route6  = Route:HOME-EDBM-EDDH-EDDG-HOME
route7  = Route:HOME-EDVK-EDLN-EDLP-HOME
route8  = Route:HOME-EDLV-HOME
route9  = Route:HOME-EDDT-HOME
route10  = Route:HOME-EDDL-EDVE-HOME
routezl = 10
Return


;=Airplane36:          B1900D
enginetype  := 5            ; Engine-Type: 0 = Piston
emptyweight := 10593        ; in lbs (as in aircraft.cfg)
payloadG    := 380          ; Payload Baggage in kg
payloadS    := 1560         ; Payload Cargo in kg
passenger   := 19           ; Passengers
bzb_range   := 630          ; max range nm, lenght of stages will be calculated 
cruispd     := 280          ; Cruise Speed, kts 
stations     = 22           ; no ":"!; max stations; if <0 = default in aircraft.cfg is ok
pilots      := 3            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 0            ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 0            ; front baggage
pasperstat  := 1            ; passengers per station
statperrow  := 2            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 590          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        = D-CxBZB      ; The name ATC uses to call your airplane
HOME         = EDDG

route1  = Route:HOME-EDDN-EDDK-EDDE-EDDF-HOME
route2  = Route:HOME-EHRD-EGLC-LFRM--HOME
route3  = Route:HOME-ELLX-EDDL-EDVC-EHRD-HOME
route4  = Route:HOME-EDBM-EDFH-EDVY-EDDN-ETNW-HOME
route5  = Route:HOME-ELLX-EHAM-EDVH-EDLW-EDDW-HOME
route6  = Route:HOME-EDDP-EDLW-HOME
route7  = Route:HOME-EDVE-EDDN-EHBK-HOME
route8  = Route:HOME-EDVE-EHAM-EDLN-EDDR-EDVY-HOME
route9  = Route:HOME-EHRD-EDDV-EDLN-EDDV-ELLX-HOME
route10  = Route:HOME-EHRD-EDLP-EDHL-HOME
routezl = 10
Return


;=Airplane37:          Fokker_Friendship
enginetype  := 5
emptyweight := 26942	
payloadG    := 660
payloadS    := 2000         ; 10587 -6600px -1760
passenger   := 44
bzb_range   := 600
cruispd     := 225
stations     = 19
pilots      := 2            ; 1= 1 Pilot at 0, 2= 2 Pilots at 0, 3= Pilot at 0 and Copilot at 1
service     := 1002         ; Service / Stewards - if not available = 0 Else stations number, max 200kg
frontbags   := 300          ; front baggage
pasperstat  := 4            ; passengers per station
statperrow  := 1            ; stations per row - normally 2 or 4; bigger airplanes not supported
aftbags     := 250          ; Rear Bags - max kg
aftcargo    := 0            ; Rear Cargo, always the last
atcID        =D-B4BZB
HOME         = EDDM

route1  = Route:HOME-LOWK-HOME
route2  = Route:HOME-EDDN-HOME
route3  = Route:HOME-EDDS-LOWS-LOWG-LIPZ-HOME
route4  = Route:HOME-LOWL-EDDN-EDBM-EDDE-HOME
route5  = Route:HOME-LOWG-LOWW-LHBP-LOWG-LOWL-HOME
route6  = Route:HOME-LIPZ-LOWS-HOME
route7  = Route:HOME-EDDE-HOME
route8  = Route:HOME-LOWI-EDDS-HOME
route9  = Route:HOME-EDDE-EDDS-HOME
route10  = Route:HOME-EDDN-LSZH-EDDF-HOME
routezl = 10
Return

